/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.ui.action;

import jp.sourceforge.f77editorplugin.editor.ui.FortranEditor;
import jp.sourceforge.f77editorplugin.editor.ui.action.EditorActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;

public class ToLowercaseAction
extends EditorActionDelegate {
    @Override
    public void run(IAction action) {
        IEditorPart editor = this.getActiveEditor();
        if (editor == null) {
            return;
        }
        if (editor instanceof FortranEditor) {
            FortranEditor fortranEditor = (FortranEditor)editor;
            try {
                TextSelection selection = (TextSelection)this.getSelection();
                if (selection != null && selection.getLength() > 0) {
                    this.doIndentWithSelection((ITextSelection)selection);
                } else {
                    this.doIndentWithoutSelection(fortranEditor.getCaretOffset());
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    protected void doIndentWithSelection(ITextSelection selection) throws BadLocationException {
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        IDocument doc = this.getDocument();
        int offset = selection.getOffset();
        int length = selection.getLength();
        String str = doc.get(offset, length);
        multiTextEdit.addChild((TextEdit)new ReplaceEdit(offset, length, str.toLowerCase()));
        multiTextEdit.apply(doc);
        this.setSelection(offset, length);
    }

    protected void doIndentWithoutSelection(int pos) {
    }

    @Override
    public boolean isEnabled(ISelection selection) {
        return selection instanceof TextSelection && ((TextSelection)selection).getLength() > 0;
    }
}

