/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.ui.action;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import jp.sourceforge.f77editorplugin.editor.ui.FortranEditor;
import jp.sourceforge.f77editorplugin.editor.ui.action.EditorActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;

public class RevisionAddAction
extends EditorActionDelegate
implements IPropertyChangeListener {
    private static boolean disabled;
    private static String startTag;
    private static String endTag;
    private static SimpleDateFormat dateFormat;

    public RevisionAddAction() {
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.propertyChange(null);
    }

    @Override
    public void dispose() {
        super.dispose();
        PreferenceManager.getStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        disabled = !PreferenceManager.getStore().getBoolean("editor.revisionComment.enable");
        dateFormat = new SimpleDateFormat(PreferenceManager.getStore().getString("editor.revisionComment.dateFormat"));
        startTag = PreferenceManager.getStore().getString("editor.revisionComment.addHeader");
        endTag = PreferenceManager.getStore().getString("editor.revisionComment.addFooter");
    }

    @Override
    public void run(IAction action) {
        IEditorPart editor = this.getActiveEditor();
        if (editor == null) {
            return;
        }
        if (editor instanceof FortranEditor) {
            FortranEditor fortranEditor = (FortranEditor)editor;
            try {
                TextSelection selection = (TextSelection)this.getSelection();
                if (selection != null && selection.getLength() > 0) {
                    this.editWithSelection(selection);
                } else {
                    this.editWithoutSelection(fortranEditor.getCaretOffset());
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private String getDateString() {
        return dateFormat.format(new Date());
    }

    private String getStartTag() {
        return startTag.replace("%d", this.getDateString());
    }

    private String getEndTag() {
        return endTag.replace("%d", this.getDateString());
    }

    private void editWithoutSelection(int caretOffset) throws BadLocationException {
        IDocument doc = this.getDocument();
        int line = doc.getLineOfOffset(caretOffset);
        int offset = doc.getLineOffset(line);
        String delim = doc.getLineDelimiter(line);
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.getStartTag()) + delim);
        caretOffset = offset + buf.length();
        buf.append(delim);
        buf.append(String.valueOf(this.getEndTag()) + delim);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChild((TextEdit)new InsertEdit(offset, buf.toString()));
        multiTextEdit.apply(doc);
        this.setSelection(caretOffset, 0);
    }

    private void editWithSelection(TextSelection selection) throws BadLocationException {
        this.editWithoutSelection(this.getDocument().getLineOffset(selection.getStartLine()));
    }

    @Override
    public boolean isEnabled(ISelection selection) {
        return !disabled && selection instanceof TextSelection;
    }
}

