/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.ui.action;

import jp.sourceforge.f77editorplugin.editor.ui.FortranEditor;
import jp.sourceforge.f77editorplugin.editor.ui.action.EditorActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;

public class LineJoinAction
extends EditorActionDelegate {
    @Override
    public void run(IAction action) {
        IDocument doc = this.getDocument();
        IEditorPart editor = this.getActiveEditor();
        if (doc == null || editor == null) {
            return;
        }
        if (editor instanceof FortranEditor) {
            FortranEditor fortranEditor = (FortranEditor)editor;
            try {
                int offset = fortranEditor.getCaretOffset();
                int line = doc.getLineOfOffset(offset);
                if (line == 0) {
                    return;
                }
                ITypedRegion source = doc.getPartition(offset);
                ITypedRegion destination = doc.getPartition(doc.getLineOffset(line - 1));
                if (source.getType().equals("__f77_comment") && destination.getType().equals("__f77_comment")) {
                    this.doLineJoinAtComment(doc, line);
                } else if (source.getType().equals("__f77_statement") && destination.getType().equals("__f77_statement")) {
                    if (source.equals(destination)) {
                        this.doLineJoinAtContinue(doc, line);
                    } else {
                        this.doLineJoinDefault(doc, line);
                    }
                } else {
                    this.doLineJoinDefault(doc, line);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private void doLineJoinDefault(IDocument doc, int line) throws BadLocationException {
        String delim = doc.getLineDelimiter(line - 1);
        int replaceStart = doc.getLineOffset(line) - delim.length();
        int replaceEnd = doc.getLineOffset(line) + doc.getLineLength(line) - doc.getLineDelimiter(line).length();
        String replaceString = doc.get(doc.getLineOffset(line), doc.getLineLength(line)).trim();
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChild((TextEdit)new ReplaceEdit(replaceStart, replaceEnd - replaceStart, replaceString));
        multiTextEdit.apply(doc);
        this.setSelection(replaceStart, 0);
    }

    private void doLineJoinAtComment(IDocument doc, int line) throws BadLocationException {
        String delim = doc.getLineDelimiter(line - 1);
        int replaceStart = doc.getLineOffset(line) - delim.length();
        int replaceEnd = doc.getLineOffset(line) + doc.getLineLength(line) - doc.getLineDelimiter(line).length();
        String replaceString = doc.get(doc.getLineOffset(line) + 1, doc.getLineLength(line) - 1).trim();
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChild((TextEdit)new ReplaceEdit(replaceStart, replaceEnd - replaceStart, replaceString));
        multiTextEdit.apply(doc);
        this.setSelection(replaceStart, 0);
    }

    private void doLineJoinAtContinue(IDocument doc, int line) throws BadLocationException {
        String delim = doc.getLineDelimiter(line - 1);
        int replaceStart = doc.getLineOffset(line) - delim.length();
        int replaceEnd = doc.getLineOffset(line) + doc.getLineLength(line) - doc.getLineDelimiter(line).length();
        String replaceString = doc.get(doc.getLineOffset(line) + 6, doc.getLineLength(line) - 6).trim();
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChild((TextEdit)new ReplaceEdit(replaceStart, replaceEnd - replaceStart, replaceString));
        multiTextEdit.apply(doc);
        this.setSelection(replaceStart, 0);
    }

    @Override
    public boolean isEnabled(ISelection selection) {
        return selection instanceof TextSelection;
    }
}

