/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.ui.action;

import jp.sourceforge.f77editorplugin.editor.ui.FortranEditor;
import jp.sourceforge.f77editorplugin.editor.ui.action.EditorActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;

public class LineFeedAction
extends EditorActionDelegate {
    private static final char INDENT_CHAR = ' ';

    @Override
    public void run(IAction action) {
        IDocument doc = this.getDocument();
        IEditorPart editor = this.getActiveEditor();
        if (doc == null || editor == null) {
            return;
        }
        if (editor instanceof FortranEditor) {
            FortranEditor fortranEditor = (FortranEditor)editor;
            try {
                int offset = fortranEditor.getCaretOffset();
                ITypedRegion region = doc.getPartition(offset);
                if (region.getType().equals("__f77_comment")) {
                    this.doLineFeedAtComment(doc, offset);
                } else if (region.getType().equals("__f77_statement")) {
                    this.doLineFeedAtStatement(doc, offset);
                } else {
                    this.doLineFeedDefault(doc, offset);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private void doLineFeedDefault(IDocument doc, int offset) {
    }

    private void doLineFeedAtStatement(IDocument doc, int offset) throws BadLocationException {
        int line = doc.getLineOfOffset(offset);
        int lineStart = doc.getLineOffset(line);
        int lineLenth = doc.getLineLength(line);
        String lineString = doc.get(lineStart, lineLenth);
        StringBuffer indent = new StringBuffer();
        int i = 6;
        while (i < lineString.length()) {
            if (lineString.charAt(i) != ' ') break;
            indent.append(' ');
            ++i;
        }
        StringBuffer buf = new StringBuffer(doc.getLineDelimiter(doc.getLineOfOffset(offset)));
        buf.append("     >");
        buf.append(indent);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChild((TextEdit)new InsertEdit(offset, buf.toString()));
        multiTextEdit.apply(doc);
        this.setSelection(offset + buf.length(), 0);
    }

    private void doLineFeedAtComment(IDocument doc, int offset) throws BadLocationException {
        int line = doc.getLineOfOffset(offset);
        int lineStart = doc.getLineOffset(line);
        int lineLenth = doc.getLineLength(line);
        String lineString = doc.get(lineStart, lineLenth);
        StringBuffer indent = new StringBuffer();
        int i = 1;
        while (i < lineString.length()) {
            if (lineString.charAt(i) != ' ') break;
            indent.append(' ');
            ++i;
        }
        StringBuffer buf = new StringBuffer(doc.getLineDelimiter(doc.getLineOfOffset(offset)));
        buf.append(doc.getChar(lineStart));
        buf.append(indent);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChild((TextEdit)new InsertEdit(offset, buf.toString()));
        multiTextEdit.apply(doc);
        this.setSelection(offset + buf.length(), 0);
    }

    @Override
    public boolean isEnabled(ISelection selection) {
        return selection instanceof TextSelection;
    }
}

