/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.ui.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public abstract class EditorActionDelegate
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private IEditorPart editorPart;
    private IWorkbenchWindow window;
    private ISelection selection;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editorPart = targetEditor;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        action.setEnabled(this.isEnabled(selection));
    }

    public abstract boolean isEnabled(ISelection var1);

    public abstract void run(IAction var1);

    protected IEditorPart getEditor() {
        return this.editorPart;
    }

    protected IDocument getDocument() {
        IEditorPart editor = this.getActiveEditor();
        if (editor instanceof AbstractTextEditor) {
            AbstractTextEditor te = (AbstractTextEditor)editor;
            return te.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        }
        return null;
    }

    protected void setSelection(int offset, int length) {
        this.setSelection((ISelection)new TextSelection(offset, length));
    }

    protected void setSelection(ISelection selection) {
        IEditorPart editor = this.getActiveEditor();
        if (editor instanceof AbstractTextEditor) {
            AbstractTextEditor te = (AbstractTextEditor)editor;
            te.getSelectionProvider().setSelection(selection);
        }
    }

    protected IEditorPart getActiveEditor() {
        return this.window.getActivePage().getActiveEditor();
    }

    public ISelection getSelection() {
        IEditorPart editor;
        if (this.selection == null && (editor = this.getActiveEditor()) instanceof AbstractTextEditor) {
            AbstractTextEditor te = (AbstractTextEditor)editor;
            this.selection = te.getSelectionProvider().getSelection();
        }
        return this.selection;
    }
}

