/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.sterategy;

import jp.sourceforge.f77editorplugin.text.FortranDocument;
import jp.sourceforge.f77editorplugin.text.detectors.FortranWordDetector;
import jp.sourceforge.f77editorplugin.text.detectors.QuoteWordDetector;
import jp.sourceforge.f77editorplugin.text.detectors.WhitespaceDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;

public class DoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer textViewer;
    private IWhitespaceDetector whitespaceDetector = new WhitespaceDetector();
    private IWordDetector wordDetector = new FortranWordDetector();
    private IWordDetector quoteSymbolDetector = new QuoteWordDetector();

    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        if (pos < 0) {
            return;
        }
        this.textViewer = part;
        boolean ret = false;
        ret = this.selectQuotedString(pos);
        if (!ret) {
            ret = this.selectWord(pos);
        }
        if (!ret) {
            ret = this.selectWhitespace(pos);
        }
        if (!ret) {
            ret = this.selectLine(pos);
        }
    }

    protected boolean selectLine(int caretPos) {
        FortranDocument doc = (FortranDocument)this.textViewer.getDocument();
        try {
            char c;
            int pos = caretPos - 1;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (doc.isLegalLineDelimiter(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (doc.isLegalLineDelimiter(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean selectQuotedString(int caretPos) {
        FortranDocument doc = (FortranDocument)this.textViewer.getDocument();
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0 && !this.quoteSymbolDetector.isWordStart(c = doc.getChar(pos))) {
                if (pos == 0 || doc.isLegalLineDelimiter(c)) {
                    return false;
                }
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length && !this.quoteSymbolDetector.isWordStart(c = doc.getChar(pos))) {
                if (pos == length || doc.isLegalLineDelimiter(c)) {
                    return false;
                }
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean selectWord(int caretPos) {
        char c;
        IDocument doc;
        block5: {
            doc = this.textViewer.getDocument();
            c = doc.getChar(caretPos);
            if (this.wordDetector.isWordPart(c)) break block5;
            return false;
        }
        try {
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!this.wordDetector.isWordPart(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!this.wordDetector.isWordPart(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean selectWhitespace(int caretPos) {
        char c;
        IDocument doc;
        block5: {
            doc = this.textViewer.getDocument();
            c = doc.getChar(caretPos);
            if (this.whitespaceDetector.isWhitespace(c)) break block5;
            return false;
        }
        try {
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!this.whitespaceDetector.isWhitespace(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!this.whitespaceDetector.isWhitespace(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.textViewer.setSelectedRange(offset, length);
    }
}

