/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import jp.sourceforge.f77editorplugin.editor.sterategy.ProjectionReconcilingStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

public class ProjectionProcessor {
    private IReconciler reconciler;
    private AnnotationModel annotationModel;

    public void setReconciler(IReconciler reconciler) {
        this.reconciler = reconciler;
    }

    public void setAnnotationModel(AnnotationModel annotationModel) {
        this.annotationModel = annotationModel;
    }

    public void updateProjectionAnnotations(Collection<ITypedRegion> regions, boolean isCollapse) {
        ArrayList<Annotation> annotationsToRemove = new ArrayList<Annotation>();
        Iterator ite = this.annotationModel.getAnnotationIterator();
        while (ite.hasNext()) {
            Annotation anno = (Annotation)ite.next();
            annotationsToRemove.add(anno);
        }
        HashMap<ProjectionAnnotation, Position> annotationsToAdd = new HashMap<ProjectionAnnotation, Position>();
        for (ITypedRegion reg : regions) {
            ProjectionAnnotation anno = new ProjectionAnnotation(isCollapse);
            Position pos = new Position(reg.getOffset(), reg.getLength());
            annotationsToAdd.put(anno, pos);
        }
        this.annotationModel.replaceAnnotations(annotationsToRemove.toArray(new Annotation[annotationsToRemove.size()]), annotationsToAdd);
    }

    public void toggleProjectionCollapse(IRegion region) {
        IReconcilingStrategy strategy = this.reconciler.getReconcilingStrategy("__f77_comment");
        if (strategy instanceof ProjectionReconcilingStrategy) {
            ProjectionReconcilingStrategy ps = (ProjectionReconcilingStrategy)strategy;
            ps.toggleProjectionCollapse();
            ps.reconcile(region);
        }
    }

    public void installProjectionSupport(ProjectionViewer projectionViewer, IAnnotationAccess annotationAccess, ISharedTextColors sharedColors) {
        ProjectionSupport projectionSupport = new ProjectionSupport(projectionViewer, annotationAccess, sharedColors);
        projectionSupport.install();
        projectionViewer.doOperation(19);
    }
}

