/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.presentation;

import jp.sourceforge.f77editorplugin.common.ui.ColorManager;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class SourceViewerPresentation
implements IPropertyChangeListener {
    private ColorManager colorManager = ColorManager.getInstance();
    private SourceViewer sourceViewer;

    public SourceViewerPresentation(SourceViewer viewer) {
        this.sourceViewer = viewer;
        this.applyPresentation();
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        PreferenceManager.getStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.applyPresentation();
    }

    public void applyPresentation() {
        RGB foreColor = PreferenceManager.getColor("editor.color.statementText");
        RGB backColor = PreferenceManager.getColor("editor.color.background");
        if (this.sourceViewer != null && this.sourceViewer instanceof SourceViewer) {
            this.sourceViewer.getTextWidget().setForeground(this.colorManager.getColor(foreColor));
            this.sourceViewer.getTextWidget().setBackground(this.colorManager.getColor(backColor));
            this.sourceViewer.invalidateTextPresentation();
        }
    }
}

