/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.presentation;

import java.util.HashSet;
import java.util.Set;
import jp.sourceforge.f77editorplugin.common.ui.ColorManager;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ColumnLinePresentation
implements IPropertyChangeListener {
    static final String COLUMN_DELIM = ",";
    static final int MARGIN_WIDTH = 1;
    static final int MARGIN_STYLE = 1;
    private ISourceViewer sourceViewer;
    private Set<IPainter> painters;
    private Color marginColor;
    private String marginColumns;
    private ColorManager colorManager = ColorManager.getInstance();

    public ColumnLinePresentation(ISourceViewer viewer) {
        this.sourceViewer = viewer;
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.applyPresentation();
    }

    public void dispose() {
        PreferenceManager.getStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void applyPresentation() {
        this.setMarginColor(PreferenceManager.getColor("editor.color.columnLine"));
        this.setMarginColumns(PreferenceManager.getString("editor.linedColumns"));
        this.clearMarginPainters();
        this.buildMarginPainters();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.applyPresentation();
    }

    public void setMarginColor(RGB rgb) {
        this.marginColor = this.colorManager.getColor(rgb);
    }

    public void setMarginColumns(String columns) {
        this.marginColumns = columns;
    }

    protected void buildMarginPainters() {
        if (!(this.sourceViewer instanceof ITextViewerExtension2)) {
            return;
        }
        if (this.painters == null) {
            this.painters = new HashSet<IPainter>();
        }
        String[] stringArray = this.marginColumns.split(COLUMN_DELIM);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            try {
                Integer col = Integer.valueOf(str);
                this.painters.add(this.createPainter(col, this.marginColor));
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        for (IPainter p : this.painters) {
            ((ITextViewerExtension2)this.sourceViewer).addPainter(p);
        }
    }

    protected void clearMarginPainters() {
        if (!(this.sourceViewer instanceof ITextViewerExtension2)) {
            return;
        }
        if (this.painters == null) {
            return;
        }
        for (IPainter p : this.painters) {
            ((ITextViewerExtension2)this.sourceViewer).removePainter(p);
        }
        this.painters.clear();
    }

    protected IPainter createPainter(Integer column, Color color) {
        MarginPainter p = new MarginPainter((ITextViewer)this.sourceViewer);
        p.setMarginRulerColumn(column.intValue());
        p.setMarginRulerColor(color);
        p.setMarginRulerWidth(1);
        p.setMarginRulerStyle(1);
        return p;
    }
}

