/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.preference.ui;

import java.util.Collection;
import java.util.HashSet;
import jp.sourceforge.f77editorplugin.common.ui.TabFolderLayout;
import jp.sourceforge.f77editorplugin.editor.Messages;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "jp.sourceforge.f77editorplugin.editor.preferences.editorPreferencePage";
    final Collection<FieldEditor> autoActivationEnables = new HashSet<FieldEditor>();
    final Collection<FieldEditor> revisionCommentEnables = new HashSet<FieldEditor>();

    public EditorPreferencePage() {
        super(1);
        this.setPreferenceStore(PreferenceManager.getStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    private Composite createFieldComposite(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 4;
        c.setLayout((Layout)layout);
        return c;
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("Preference.Editor.View.label"));
        item.setControl(this.createViewerPreferences((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(Messages.getString("Preference.Editor.Color.label"));
        item.setControl(this.createColorPreferences((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(Messages.getString("Preference.Editor.RevisionComment.label"));
        item.setControl(this.createRevisionCommentPreferences((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(Messages.getString("Preference.Editor.ContentAssist.label"));
        item.setControl(this.createContentAssistPreferences((Composite)folder));
        Dialog.applyDialogFont((Control)folder);
    }

    private Control createContentAssistPreferences(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        final Composite fieldComposite = this.createFieldComposite(composite);
        BooleanFieldEditor enableVariableNames = new BooleanFieldEditor("editor.contentAssist.variableNameProposal", Messages.getString("Preference.Editor.ContentAssist.VariableNameProposals.label"), fieldComposite);
        BooleanFieldEditor enableFunctionNames = new BooleanFieldEditor("editor.contentAssist.functionNameProposal", Messages.getString("Preference.Editor.ContentAssist.FunctionNameProposals.label"), fieldComposite);
        BooleanFieldEditor enableSyntaxWords = new BooleanFieldEditor("editor.contentAssist.syntaxWordProposal", Messages.getString("Preference.Editor.ContentAssist.SyntaxWordProposals.label"), fieldComposite);
        this.addField((FieldEditor)enableSyntaxWords);
        this.addField((FieldEditor)enableVariableNames);
        this.addField((FieldEditor)enableFunctionNames);
        BooleanFieldEditor enableAutoActivation = new BooleanFieldEditor("editor.contentAssist.autoActivation.enable", Messages.getString("Preference.Editor.ContentAssist.EnableAutoActivation.label"), fieldComposite){

            public void load() {
                super.load();
                EditorPreferencePage.this.changeAutoActivationEnables(this.getBooleanValue(), fieldComposite);
            }

            protected void doLoadDefault() {
                super.doLoadDefault();
                EditorPreferencePage.this.changeAutoActivationEnables(this.getBooleanValue(), fieldComposite);
            }

            protected void valueChanged(boolean oldValue, boolean newValue) {
                super.valueChanged(oldValue, newValue);
                EditorPreferencePage.this.changeAutoActivationEnables(newValue, fieldComposite);
            }
        };
        IntegerFieldEditor autoActivationDelay = new IntegerFieldEditor("editor.contentAssist.autoActivation.delay", Messages.getString("Preference.Editor.ContentAssist.AutoActivationDelay.label"), fieldComposite);
        this.autoActivationEnables.add((FieldEditor)autoActivationDelay);
        this.addField((FieldEditor)enableAutoActivation);
        this.addField((FieldEditor)autoActivationDelay);
        return composite;
    }

    private void changeAutoActivationEnables(Boolean newValue, Composite parent) {
        for (FieldEditor e : this.autoActivationEnables) {
            e.setEnabled(newValue.booleanValue(), parent);
        }
    }

    private Control createRevisionCommentPreferences(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        final Composite fieldComposite = this.createFieldComposite(composite);
        BooleanFieldEditor enableRevisionComment = new BooleanFieldEditor("editor.revisionComment.enable", Messages.getString("Preference.Editor.RevisionComment.Enable.label"), fieldComposite){

            public void load() {
                super.load();
                EditorPreferencePage.this.changeRevisionCommentEnables(this.getBooleanValue(), fieldComposite);
            }

            protected void doLoadDefault() {
                super.doLoadDefault();
                EditorPreferencePage.this.changeRevisionCommentEnables(this.getBooleanValue(), fieldComposite);
            }

            protected void valueChanged(boolean oldValue, boolean newValue) {
                super.valueChanged(oldValue, newValue);
                EditorPreferencePage.this.changeRevisionCommentEnables(newValue, fieldComposite);
            }
        };
        StringFieldEditor replaceStart = new StringFieldEditor("editor.revisionComment.modifyHeader", Messages.getString("Preference.Editor.RevisionComment.ModifyHeader.label"), fieldComposite);
        StringFieldEditor replaceEnd = new StringFieldEditor("editor.revisionComment.modifyFooter", Messages.getString("Preference.Editor.RevisionComment.ModifyFooter.label"), fieldComposite);
        StringFieldEditor insertStart = new StringFieldEditor("editor.revisionComment.addHeader", Messages.getString("Preference.Editor.RevisionComment.AddHeader.label"), fieldComposite);
        StringFieldEditor insertEnd = new StringFieldEditor("editor.revisionComment.addFooter", Messages.getString("Preference.Editor.RevisionComment.AddFooter.label"), fieldComposite);
        StringFieldEditor removeStart = new StringFieldEditor("editor.revisionComment.removeHeader", Messages.getString("Preference.Editor.RevisionComment.RemoveHeader.label"), fieldComposite);
        StringFieldEditor removeEnd = new StringFieldEditor("editor.revisionComment.removeFooter", Messages.getString("Preference.Editor.RevisionComment.RemoveFooter.label"), fieldComposite);
        StringFieldEditor dateFormat = new StringFieldEditor("editor.revisionComment.dateFormat", Messages.getString("Preference.Editor.RevisionComment.DateFormat.label"), fieldComposite);
        this.revisionCommentEnables.add((FieldEditor)replaceStart);
        this.revisionCommentEnables.add((FieldEditor)replaceEnd);
        this.revisionCommentEnables.add((FieldEditor)insertStart);
        this.revisionCommentEnables.add((FieldEditor)insertEnd);
        this.revisionCommentEnables.add((FieldEditor)removeStart);
        this.revisionCommentEnables.add((FieldEditor)removeEnd);
        this.revisionCommentEnables.add((FieldEditor)dateFormat);
        this.addField((FieldEditor)enableRevisionComment);
        this.addField((FieldEditor)replaceStart);
        this.addField((FieldEditor)replaceEnd);
        this.addField((FieldEditor)insertStart);
        this.addField((FieldEditor)insertEnd);
        this.addField((FieldEditor)removeStart);
        this.addField((FieldEditor)removeEnd);
        this.addField((FieldEditor)dateFormat);
        return composite;
    }

    private void changeRevisionCommentEnables(Boolean newValue, Composite parent) {
        for (FieldEditor e : this.revisionCommentEnables) {
            e.setEnabled(newValue.booleanValue(), parent);
        }
    }

    private Control createColorPreferences(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Composite fieldComposite = this.createFieldComposite(composite);
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.background", Messages.getString("Preference.Editor.Color.Background.label"), fieldComposite));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.statementText", Messages.getString("Preference.Editor.Color.StatementText.label"), fieldComposite));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.syntaxWord", Messages.getString("Preference.Editor.Color.Syntax.label"), fieldComposite));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.functionName", Messages.getString("Preference.Editor.Color.Function.label"), fieldComposite));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.commentText", Messages.getString("Preference.Editor.Color.Comment.label"), fieldComposite));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.characterConstant", Messages.getString("Preference.Editor.Color.Charactor.label"), fieldComposite));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.continueSymbol", Messages.getString("Preference.Editor.Color.ContinueSymbol.label"), fieldComposite));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.statementLabel", Messages.getString("Preference.Editor.Color.StatementLabel.label"), fieldComposite));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.ignoreText", Messages.getString("Preference.Editor.Color.NonFactional.label"), fieldComposite));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.columnLine", Messages.getString("Preference.Editor.Color.ColumnLine.label"), fieldComposite));
        return composite;
    }

    private Control createViewerPreferences(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Composite fieldComposite = this.createFieldComposite(composite);
        this.addField((FieldEditor)new BooleanFieldEditor("editor.enableCommentFolding", Messages.getString("Preference.Editor.View.EnableCommnetFolding.label"), fieldComposite));
        this.addField((FieldEditor)new IntegerFieldEditor("editor.indentWidth", Messages.getString("Preference.Editor.View.IndentWidth.label"), fieldComposite));
        this.addField((FieldEditor)new StringFieldEditor("editor.linedColumns", Messages.getString("Preference.Editor.View.ColumnLine.label"), fieldComposite));
        return composite;
    }
}

