/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.outline.ui;

import jp.sourceforge.f77editorplugin.outline.internal.OutlineContentProvider;
import jp.sourceforge.f77editorplugin.outline.internal.OutlineElement;
import jp.sourceforge.f77editorplugin.outline.internal.OutlineLabelProvider;
import jp.sourceforge.f77editorplugin.outline.preference.PreferenceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class OutlinePage
extends ContentOutlinePage
implements IPropertyChangeListener {
    protected Object outlineInput;
    protected IDocumentProvider documentProvider;
    protected ITextEditor textEditor;

    public OutlinePage(IDocumentProvider provider, ITextEditor editor) {
        this.documentProvider = provider;
        this.textEditor = editor;
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new OutlineContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.outlineInput != null) {
            viewer.setInput(this.outlineInput);
        }
        viewer.expandAll();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.textEditor.resetHighlightRange();
        } else {
            OutlineElement node = (OutlineElement)((IStructuredSelection)selection).getFirstElement();
            int start = node.getPosition().getOffset();
            int length = node.getPosition().getLength();
            try {
                this.textEditor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.textEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(Object input) {
        this.outlineInput = input;
        this.update();
    }

    public void update() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            this.updateViewer(viewer);
        }
    }

    private void updateViewer(TreeViewer viewer) {
        Control control = viewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.outlineInput);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    public Object getOutlineInput() {
        return this.outlineInput;
    }

    public void setOutlineInput(Object outlineInput) {
        this.outlineInput = outlineInput;
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public void setDocumentProvider(IDocumentProvider documentProvider) {
        this.documentProvider = documentProvider;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateViewer(this.getTreeViewer());
    }
}

