/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.outline.rules;

import java.util.Map;
import jp.sourceforge.f77editorplugin.outline.preference.PreferenceManager;
import jp.sourceforge.f77editorplugin.text.preference.DefinitionWord;
import jp.sourceforge.f77editorplugin.text.rules.WordMatchRule;
import org.eclipse.jface.text.rules.IToken;

public class OutlineWordRule
extends WordMatchRule {
    private String fTargetCategory;
    protected Map<String, DefinitionWord> definitionWords;

    public OutlineWordRule(IToken successToken, String targetCategory) {
        super(successToken);
        this.fTargetCategory = targetCategory;
        PreferenceManager.getInstance().buildOutlineWordMap();
        this.definitionWords = PreferenceManager.getInstance().getWordMap();
    }

    public void initialize() {
        super.initialize();
    }

    protected boolean isDefinitionWord(String str) {
        String word = str.toUpperCase().replaceAll("\\s", "");
        if (this.definitionWords.containsKey(word)) {
            DefinitionWord w = this.definitionWords.get(word);
            return w.getCategory().equals(this.fTargetCategory);
        }
        return false;
    }

    protected boolean isDefinitionWordPart(String str) {
        for (String key : this.definitionWords.keySet()) {
            if (key.indexOf(str) == -1 || key.equals(str)) continue;
            return true;
        }
        return false;
    }
}

