/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.outline;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import jp.sourceforge.f77editorplugin.outline.Activator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class Images {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("jp.sourceforge.f77editorplugin.outline.images");
    private static final String PROPERTIES_PREFIX_ICON = "icons.outline.";
    private static final String DEFALUT_ICON_KEY = "icons.outline.default";
    private static ImageRegistry imageRegistry = new ImageRegistry();

    private static String getString(String key) {
        return Images.getString(key, "");
    }

    private static String getString(String key, String defaultString) {
        String str = defaultString;
        if (RESOURCE_BUNDLE.containsKey(key)) {
            str = RESOURCE_BUNDLE.getString(key);
        }
        return str;
    }

    public static Image getImage(String path) {
        Image img = imageRegistry.get(path);
        if (img == null) {
            try {
                URL location = FileLocator.toFileURL((URL)Activator.getDefault().getBundle().getEntry(path));
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)location);
                imageRegistry.put(path, descriptor);
                img = descriptor.createImage();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return img;
    }

    public static Image getIconImage(String key) {
        return Images.getImage(Images.getIconPath(key, DEFALUT_ICON_KEY));
    }

    public static Image getIconImage(String key, String defaultKey) {
        return Images.getImage(Images.getIconPath(key, defaultKey));
    }

    public static String getIconPath(String key) {
        return Images.getString(PROPERTIES_PREFIX_ICON + key);
    }

    public static String getIconPath(String key, String defaultKey) {
        return Images.getString(PROPERTIES_PREFIX_ICON + key, PROPERTIES_PREFIX_ICON + defaultKey);
    }
}

