/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.scanners;

import jp.sourceforge.f77editorplugin.text.detectors.CommentLineDetector;
import jp.sourceforge.f77editorplugin.text.detectors.MasterStatementLineDetector;
import jp.sourceforge.f77editorplugin.text.detectors.SlaveStatementLineDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class PartitionScanner
implements IPartitionTokenScanner {
    private MasterStatementLineDetector masterStatementDetector = new MasterStatementLineDetector();
    private SlaveStatementLineDetector slaveStatementDetector = new SlaveStatementLineDetector();
    private CommentLineDetector commentDetector = new CommentLineDetector();
    private IDocument doc;
    private Position pos;
    private IToken lastToken;
    private Position lastPosition;

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        int delta;
        if (partitionOffset > -1 && (delta = offset - partitionOffset) > 0) {
            this.setRange(document, partitionOffset, length + delta);
            return;
        }
        this.setRange(document, offset, length);
    }

    public static String[] getContentTypes() {
        return new String[]{"__f77_comment", "__f77_statement"};
    }

    public int getTokenLength() {
        if (this.lastPosition != null) {
            return this.lastPosition.length;
        }
        return 0;
    }

    public int getTokenOffset() {
        if (this.lastPosition != null) {
            return this.lastPosition.offset;
        }
        return 0;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.doc = document;
        this.pos = new Position(offset, length);
    }

    public IToken nextToken() {
        if (this.pos.length <= 0) {
            this.lastToken = Token.EOF;
        } else {
            int offset = this.pos.offset;
            try {
                this.lastToken = this.evaluate();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.lastPosition = new Position(offset, this.pos.offset - offset);
        }
        return this.lastToken;
    }

    private String readLine() throws BadLocationException {
        if (this.pos.offset >= this.doc.getLength()) {
            return null;
        }
        int line = this.doc.getLineOfOffset(this.pos.offset);
        int offset = this.doc.getLineOffset(line);
        int length = this.doc.getLineLength(line);
        if (offset < this.pos.offset) {
            length -= this.pos.offset - offset;
            offset = this.pos.offset;
        }
        if (length > this.pos.length) {
            length = this.pos.length;
        }
        String str = this.doc.get(offset, length);
        this.pos.offset += str.length();
        this.pos.length -= str.length();
        return str;
    }

    private void unread(int length) {
        this.pos.offset -= length;
        this.pos.length += length;
    }

    private int getColumn() throws BadLocationException {
        return this.doc.getLineOffset(this.doc.getLineOfOffset(this.pos.offset)) - this.pos.offset;
    }

    private IToken evaluate() throws BadLocationException {
        if (this.getColumn() != 0) {
            this.readLine();
            return Token.UNDEFINED;
        }
        IToken token = Token.UNDEFINED;
        String line = this.readLine();
        if (this.masterStatementDetector.isLineStart(line)) {
            token = new Token((Object)"__f77_statement");
            int unreadLength = 0;
            while ((line = this.readLine()) != null) {
                if (this.slaveStatementDetector.isLineStart(line)) {
                    unreadLength = 0;
                    continue;
                }
                unreadLength += line.length();
                break;
            }
            this.unread(unreadLength);
        } else if (this.slaveStatementDetector.isLineStart(line)) {
            token = new Token((Object)"__f77_statement");
            int unreadLength = 0;
            while ((line = this.readLine()) != null) {
                if (this.slaveStatementDetector.isLineStart(line)) {
                    unreadLength = 0;
                    continue;
                }
                unreadLength += line.length();
                break;
            }
            this.unread(unreadLength);
        } else if (this.commentDetector.isLineStart(line)) {
            token = new Token((Object)"__f77_comment");
            int unreadLength = 0;
            while ((line = this.readLine()) != null) {
                if (this.commentDetector.isLineStart(line)) {
                    unreadLength = 0;
                    continue;
                }
                unreadLength += line.length();
                break;
            }
            this.unread(unreadLength);
        }
        return token;
    }
}

