/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.rules;

import jp.sourceforge.f77editorplugin.text.detectors.FortranWordDetector;
import jp.sourceforge.f77editorplugin.text.detectors.WhitespaceDetector;
import jp.sourceforge.f77editorplugin.text.rules.AbstractRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public abstract class WordMatchRule
extends AbstractRule {
    private IWordDetector wordDetector = new FortranWordDetector();
    private IWhitespaceDetector whitespaceDetector = new WhitespaceDetector();

    public WordMatchRule(IToken successToken) {
        super(successToken);
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (scanner.getColumn() < 6 || scanner.getColumn() > 72) {
            return Token.UNDEFINED;
        }
        int count = 0;
        scanner.unread();
        char pre = (char)scanner.read();
        char c = (char)scanner.read();
        ++count;
        if (!this.wordDetector.isWordStart(c) || this.wordDetector.isWordPart(pre)) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        StringBuffer buf = new StringBuffer();
        do {
            if (scanner.getColumn() > 6 && this.wordDetector.isWordPart(c)) {
                buf.append(c);
            }
            c = (char)scanner.read();
            ++count;
        } while (c != '\uffff' && scanner.getColumn() < 73 && this.isWordPart(c, buf));
        if (this.isDefinitionWord(buf.toString())) {
            scanner.unread();
            return this.getSuccessToken();
        }
        int i = 0;
        while (i < count) {
            scanner.unread();
            ++i;
        }
        return Token.UNDEFINED;
    }

    private boolean isWordPart(char c, CharSequence preSequence) {
        if (this.wordDetector.isWordPart(c)) {
            return true;
        }
        if (!this.whitespaceDetector.isWhitespace(c)) {
            return false;
        }
        if (this.isDefinitionWord(preSequence.toString())) {
            return false;
        }
        return this.isDefinitionWordPart(preSequence.toString().toUpperCase());
    }

    protected abstract boolean isDefinitionWord(String var1);

    protected abstract boolean isDefinitionWordPart(String var1);
}

