/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.rules;

import jp.sourceforge.f77editorplugin.text.detectors.NumericWordDetector;
import jp.sourceforge.f77editorplugin.text.rules.AbstractRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class NumericWordRule
extends AbstractRule {
    private IWordDetector wordDetector = new NumericWordDetector();

    public NumericWordRule(IToken successToken) {
        super(successToken);
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (scanner.getColumn() < 6 || scanner.getColumn() > 72) {
            return Token.UNDEFINED;
        }
        char c = (char)scanner.read();
        if (!this.wordDetector.isWordStart(c)) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        StringBuffer buf = new StringBuffer();
        do {
            if (scanner.getColumn() <= 6 || !this.wordDetector.isWordPart(c)) continue;
            buf.append(c);
        } while ((c = (char)scanner.read()) != '\uffff' && scanner.getColumn() < 73 && this.wordDetector.isWordPart(c));
        scanner.unread();
        return this.getSuccessToken();
    }
}

