/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.rules;

import jp.sourceforge.f77editorplugin.text.detectors.FortranWordDetector;
import jp.sourceforge.f77editorplugin.text.rules.AbstractRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class HollerithConstantRule
extends AbstractRule {
    private static final String NUMBER_SYMBOLS = "0123456789";
    private IWordDetector fortranWordDetector = new FortranWordDetector();
    private int remainingForHolerith = 0;

    public HollerithConstantRule(IToken successToken) {
        super(successToken);
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (scanner.getColumn() < 6 || scanner.getColumn() > 72) {
            return Token.UNDEFINED;
        }
        if (resume && this.remainingForHolerith > 0) {
            this.searchEndForHollerith(scanner);
            return this.getSuccessToken();
        }
        scanner.unread();
        char c0 = (char)scanner.read();
        char c = (char)scanner.read();
        int count = 1;
        StringBuffer buf = new StringBuffer();
        if (!this.fortranWordDetector.isWordPart(c0) && this.isHollerithLengthSymbol(c)) {
            do {
                if (scanner.getColumn() > 6 && scanner.getColumn() < 73 && this.isHollerithLengthSymbol(c)) {
                    buf.append(c);
                }
                c = (char)scanner.read();
                ++count;
            } while (c != '\uffff' && this.isHollerithLengthSymbol(c));
        }
        if (buf.length() > 0 && c == 'H') {
            this.remainingForHolerith = Integer.parseInt(buf.toString());
            this.searchEndForHollerith(scanner);
            return this.getSuccessToken();
        }
        int i = 0;
        while (i < count) {
            scanner.unread();
            ++i;
        }
        return Token.UNDEFINED;
    }

    private void searchEndForHollerith(ICharacterScanner scanner) {
        char c;
        do {
            c = (char)scanner.read();
            if (scanner.getColumn() > 72) {
                this.isResumed = true;
                return;
            }
            if (c == '\r' || c == '\n') {
                this.isResumed = false;
                return;
            }
            --this.remainingForHolerith;
        } while (c != '\uffff' && this.remainingForHolerith > 0);
        this.isResumed = false;
    }

    private boolean isHollerithLengthSymbol(char c) {
        return NUMBER_SYMBOLS.indexOf(c) != -1;
    }
}

