/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.presentation;

import java.util.ArrayList;
import jp.sourceforge.f77editorplugin.text.TokenProvider;
import jp.sourceforge.f77editorplugin.text.scanners.RoopBlockScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HighlightRegionProcessor {
    private RoopBlockScanner fScanner = new RoopBlockScanner();

    public IRegion computeHighlightRegion(IDocument document, int offset) throws BadLocationException {
        RoopStart start = this.computHilightRegionStart(document, offset);
        IRegion region = this.computHilightRegionEnd(document, start);
        return region;
    }

    private RoopStart computHilightRegionStart(IDocument document, int offset) throws BadLocationException {
        ITypedRegion[] regions = document.getDocumentPartitioner().computePartitioning(0, offset - 1);
        ArrayList<String> labels = new ArrayList<String>();
        int depth = 0;
        RoopStart start = null;
        int count = 0;
        int i = regions.length - 1;
        while (i > -1) {
            ++count;
            ITypedRegion reg = regions[i];
            if (reg.getType().equals("__f77_statement")) {
                IToken t;
                this.fScanner.setRange(document, reg.getOffset(), reg.getLength());
                String label = null;
                String syntax = null;
                String numeric = null;
                while ((t = this.fScanner.nextToken()) != Token.EOF) {
                    if (label == null && TokenProvider.STATEMENT_LABEL.equals(t)) {
                        label = document.get(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength()).toUpperCase().replaceAll("\\s", "");
                    }
                    if (syntax == null && TokenProvider.STATEMENT_SYNTAX_WORD.equals(t)) {
                        syntax = document.get(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength()).toUpperCase().replaceAll("\\s", "");
                    }
                    if (numeric == null && TokenProvider.STATEMENT_NUMERIC.equals(t)) {
                        numeric = document.get(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength()).toUpperCase().replaceAll("\\s", "");
                    }
                    if (TokenProvider.STATEMENT_WORD.equals(t)) break;
                }
                if ("ENDDO".equals(syntax)) {
                    ++depth;
                }
                if ("DO".equals(syntax) && start == null) {
                    if (numeric != null && !labels.contains(numeric)) {
                        start = new RoopStart(reg.getOffset(), numeric);
                        break;
                    }
                    if (numeric == null && depth == 0) {
                        start = new RoopStart(reg.getOffset());
                        break;
                    }
                    if (numeric == null) {
                        --depth;
                    }
                }
                if (count > 1 && label != null) {
                    labels.add(label);
                }
            }
            --i;
        }
        return start;
    }

    private IRegion computHilightRegionEnd(IDocument document, RoopStart start) throws BadLocationException {
        if (start == null) {
            return null;
        }
        ITypedRegion[] regions = document.getDocumentPartitioner().computePartitioning(start.getOffset(), document.getLength() - start.getOffset());
        int depth = 0;
        int i = 0;
        while (i < regions.length) {
            ITypedRegion reg = regions[i];
            if (reg.getType().equals("__f77_statement")) {
                IToken t;
                this.fScanner.setRange(document, reg.getOffset(), reg.getLength());
                String label = null;
                String syntax = null;
                String numeric = null;
                while ((t = this.fScanner.nextToken()) != Token.EOF) {
                    if (label == null && TokenProvider.STATEMENT_LABEL.equals(t)) {
                        label = document.get(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength()).toUpperCase().replaceAll("\\s", "");
                    }
                    if (syntax == null && TokenProvider.STATEMENT_SYNTAX_WORD.equals(t)) {
                        syntax = document.get(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength()).toUpperCase().replaceAll("\\s", "");
                    }
                    if (numeric == null && TokenProvider.STATEMENT_NUMERIC.equals(t)) {
                        numeric = document.get(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength()).toUpperCase().replaceAll("\\s", "");
                    }
                    if (TokenProvider.STATEMENT_WORD.equals(t)) break;
                }
                if (start.hasLabel()) {
                    if (start.getLabel().equals(label)) {
                        return new Region(start.getOffset(), this.fScanner.getTokenOffset() + this.fScanner.getTokenLength() - start.getOffset());
                    }
                } else {
                    if ("ENDDO".equals(syntax) && depth == 0) {
                        return new Region(start.getOffset(), this.fScanner.getTokenOffset() + this.fScanner.getTokenLength() - start.getOffset());
                    }
                    if ("DO".equals(syntax) && label == null && i > 0) {
                        ++depth;
                    } else if ("ENDDO".equals(syntax) && depth > 0) {
                        --depth;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private class RoopStart {
        private int offset = 0;
        private String label = null;

        public RoopStart(int offset) {
            this.offset = offset;
        }

        public RoopStart(int offset, String label) {
            this.offset = offset;
            this.label = label;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean hasLabel() {
            return this.label != null;
        }
    }
}

