/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.preference.ui;

import jp.sourceforge.f77editorplugin.common.ui.dialog.AbstractTableItemDialog;
import jp.sourceforge.f77editorplugin.common.ui.dialog.ITableItemDialog;
import jp.sourceforge.f77editorplugin.text.Messages;
import jp.sourceforge.f77editorplugin.text.preference.PreferenceManager;
import jp.sourceforge.f77editorplugin.text.preference.codec.WordItemCodec;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WordItemDialog
extends AbstractTableItemDialog {
    public WordItemDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("Preference.Syntax.Word.Dialog.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label wordLabel = new Label(dialogArea, 0);
        wordLabel.setText(Messages.getString("Preference.Syntax.Word.WordColumn.label"));
        Text wordText = new Text(dialogArea, 2052);
        wordText.setLayoutData((Object)new GridData(768));
        wordText.setText(this.fKey);
        wordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text source = (Text)e.getSource();
                WordItemDialog.this.fKey = source.getText();
            }
        });
        WordItemCodec codec = new WordItemCodec(Messages.getBundle(), "Preference.Syntax.Word.Category.");
        final String[] categories = codec.parseCategories(PreferenceManager.getStore().getString("preferenece.store.syntaxWords"));
        Label typeLabel = new Label(dialogArea, 0);
        typeLabel.setText(Messages.getString("Preference.Syntax.Word.TypeColumn.label"));
        int initialIndex = 0;
        Combo typeSelection = new Combo(dialogArea, 8);
        int i = 0;
        while (i < categories.length) {
            typeSelection.add(codec.localize(categories[i]), i);
            if (categories[i].equals(this.fValue)) {
                initialIndex = i;
            }
            ++i;
        }
        typeSelection.select(initialIndex);
        this.fValue = categories[typeSelection.getSelectionIndex()];
        this.fDescription = typeSelection.getText();
        typeSelection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo source = (Combo)e.getSource();
                WordItemDialog.this.fValue = categories[source.getSelectionIndex()];
                WordItemDialog.this.fDescription = source.getText();
            }
        });
        return dialogArea;
    }

    public ITableItemDialog CreateInstance() {
        return new WordItemDialog(this.getParentShell());
    }
}

