/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.preference.codec;

import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.f77editorplugin.core.internal.preference.IPreferenceCodec;
import jp.sourceforge.f77editorplugin.core.internal.preference.PreferenceCodec;

public class FunctionItemCodec
extends PreferenceCodec
implements IPreferenceCodec {
    public static final int INDEX_NAME = 0;
    public static final int INDEX_CATEGORY = 1;
    private static final Pattern PARAM_PATTERN = Pattern.compile("(.+)\\((.*)\\)");

    public FunctionItemCodec() {
    }

    public FunctionItemCodec(ResourceBundle bundle, String prefix) {
        super(bundle, prefix);
    }

    public void put(String name, String params, String category) {
        String key = String.valueOf(name) + "(" + params + ")";
        this.put(key, category);
    }

    protected String[] createItem(String[] elements) {
        String[] item;
        String name = "";
        String param = "";
        String category = "";
        switch (elements.length - 1) {
            case 1: {
                category = elements[1];
            }
            case 0: {
                Matcher m = PARAM_PATTERN.matcher(elements[0]);
                if (m.matches()) {
                    if (m.groupCount() > 0) {
                        name = m.group(1);
                    }
                    if (m.groupCount() > 1) {
                        param = m.group(2);
                    }
                } else {
                    name = elements[0];
                }
                item = new String[]{name, param, category};
                break;
            }
            default: {
                item = null;
            }
        }
        return item;
    }
}

