/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.preference;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefinitionWord {
    private static Pattern REGEX_PARAMED_WORD = Pattern.compile("(.+)(\\(.*\\))");
    public static final String SPACE = " ";
    private Type fType;
    private String fName;
    private String fParams;
    private String fCategory;
    private String fDescription;

    public DefinitionWord(Type type, String[] definitions) {
        this.fType = type;
        this.fName = definitions[0];
        this.fDescription = definitions[1];
        this.fCategory = definitions[2];
        Matcher m = REGEX_PARAMED_WORD.matcher(definitions[0]);
        if (m.matches()) {
            this.fName = m.group(1);
            this.fParams = m.group(2);
        } else {
            this.fName = definitions[0];
            this.fParams = "";
        }
    }

    public boolean hasType(Type type) {
        return this.fType == type;
    }

    public Type getType() {
        return this.fType;
    }

    public String getName() {
        return this.fName;
    }

    public String getParams() {
        return this.fParams;
    }

    public String getCategory() {
        return this.fCategory;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getKey() {
        return this.fName.toUpperCase();
    }

    public boolean hasAlias() {
        return this.fName.contains(SPACE);
    }

    public String getAliasKey() {
        return this.fName.replace(SPACE, "").toUpperCase();
    }

    public boolean isDaclaration() {
        return "declaration".equals(this.fCategory);
    }

    public static enum Type {
        SYNTAXWORD,
        OUTLINEWORD,
        FUNCTION;

    }
}

