/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.contentassist;

import jp.sourceforge.f77editorplugin.text.Images;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public class ProposalBuilder {
    private static final String SEPARATER = "  : ";

    protected CompletionProposal createProposal(String qualifier, int documentOffset, String word, String description) {
        return this.createProposal(qualifier, documentOffset, word, new String[]{description});
    }

    protected CompletionProposal createProposal(String qualifier, int documentOffset, String word, String[] descriptions) {
        int length = qualifier.length();
        int replacementOffset = documentOffset - length;
        int replacementLength = length;
        int cursorPosition = word.length();
        String displayString = this.createDisplayString(word, descriptions);
        Image img = this.getIconImage(descriptions);
        ContextInformation info = new ContextInformation("contextDisplayString", "informationDisplayString");
        CompletionProposal proposal = img != null ? new CompletionProposal(word, replacementOffset, replacementLength, cursorPosition, img, displayString, (IContextInformation)info, "additionalProposalInfo") : new CompletionProposal(word, replacementOffset, replacementLength, cursorPosition);
        return proposal;
    }

    private String createDisplayString(String word, String[] types) {
        StringBuffer buf = new StringBuffer();
        buf.append(word);
        buf.append(SEPARATER);
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(types[i]);
            ++i;
        }
        return buf.toString();
    }

    private Image getIconImage(String[] descriptions) {
        int type = 1;
        String[] stringArray = descriptions;
        int n = descriptions.length;
        int n2 = 0;
        while (n2 < n) {
            String desc = stringArray[n2];
            if (desc.toUpperCase().startsWith("INTEGER")) {
                type |= 4;
            } else if (desc.toUpperCase().startsWith("REAL")) {
                type |= 8;
            } else if (desc.toUpperCase().startsWith("DOUBLEPRECISION")) {
                type |= 8;
            } else if (desc.toUpperCase().startsWith("CHARACTER")) {
                type |= 0x10;
            } else if (desc.toUpperCase().startsWith("LOGICAL")) {
                type |= 0x20;
            } else if (desc.toUpperCase().startsWith("FUNCTION")) {
                type |= 0x40;
            }
            ++n2;
        }
        String key = "icons.contentassist.default";
        if ((type & 4) > 0) {
            key = "icons.contentassist.integer";
        } else if ((type & 8) > 0) {
            key = "icons.contentassist.real";
        } else if ((type & 0x10) > 0) {
            key = "icons.contentassist.character";
        } else if ((type & 0x20) > 0) {
            key = "icons.contentassist.logical";
        } else if ((type & 0x40) > 0) {
            key = "icons.contentassist.function";
        }
        return Images.getIconImage(key);
    }

    protected static interface IProposalType {
        public static final int DEFAULT = 1;
        public static final int INTEGER = 4;
        public static final int REAL = 8;
        public static final int CHARACTER = 16;
        public static final int LOGICAL = 32;
        public static final int FUNCTION = 64;
    }
}

