/*
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 *
 * () ȉ͓{̕₷l̂߂ɁAp̒쌠\
 * ͂łBȒ쌠́Ap̌{ɏ]B
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * ύX̗Lɂ炸A\[XуoCi`̍ĔzzїṕA
 * ȉ̏𖞂Ă΁AB
 *
 * 1. \[XER[h̍ĔzźAL̒쌠\ȀځAсA
 * ȉ̖ƐӎۑȂ΂ȂȂB
 *
 * 2. oCi`̍ĔzźAL̒쌠\ȀځAсA
 * ̖ƐӎA̔zzɕtA邢͂̑̎̂
 * ɖLȂ΂ȂȂB
 *
 * 3. Oēʂɋ𓾂ȂÃ\tgEFAhi
 * ̔î߂ɁA̒쌠Җ𗘗pĂ͂ȂȂB
 *
 * ̃\tgEFÁû܂܂̌`Łv񋟂AI邢͌O̕ۏ
 * ́AppѓړIւ̓Kɑ΂錾O̕ۏ؂܂݁A܂
 * Ɍ炸A݂ȂBƂȉ̂悤ȑQ̉\Ă
 * ƂĂAǂ̂悤Ȍ`ɂ낱̃\tgEFA̗p甭
 * āA̒쌠҂́A(֐iT[rX̒B; pAf[^A
 * 邢͗v̑; 邢͉cƂ̒f܂ށA܂炾Ɍ炸)
 * ړIɁAԐړIɁARɁAʂɁAA邢́AKRIɐĂ܂
 * Qɑ΂ӔC͂ȂAȂӔC_ł_̗LɌW炸
 * ȐӔC͂ȂA܂(ߎ邢͂̑܂)s@sׂɑ΂ĂӔC͂
 * B
 *
 */

/*
 * NX}\[X𐶐DynamicDrawpvOC
 *   ExportSrc.dll
 *
 *   ExtractInfo    :NX}ClassInfo֕Kvȏ̒osNX
 *
 * Copyright (c) 2002 matsumo. All rights reserved.
 *
 * @(#) $Id: ExtractInfo.cpp,v 1.8 2002/07/13 10:46:15 matsumo Exp $
 *
 */

#include "stdafx.h"
#include <tchar.h>		// For _TCHAR.
#include "Module.h"		// For FMpgGetModule().
#include "ExtractInfo.h"

extern const wchar_t*	s_wcpComponentName;
extern const wchar_t*	s_wcpComponentVersion;

/////////////////////////////////////////////////////////////////////////////////
//OĂ΂郁\bh

/*****************************************************************************/
/* \[Xo͂̃j[IɌĂ΂										 */
/* tH_IɂׂẴV[gAimF								 */
/*  ENTRY : 				:												 */
/*  RETURN: ES_Err::code	:G[R[h									 */
/*****************************************************************************/
ES_Err::code ExtractInfo::exec(wstring &path)
{
	//UMLev[ggpĂ邩ǂmF
	const FCEnvExp* pEnv = (const FCEnvExp*)FMpgGetMolipMain()->GetEnv();
	const FDChipGroupIDVector& cgidv = pEnv->GetFreqChipGroupVector();
	if(cgidv.size() != 1) return(ES_Err::BAD_TEMPLATE);	//ev[gI or Ⴄev[ggp
	wstring cgidname = pEnv->cgid2name(cgidv[0]);
	if(cgidname.compare(L"UMLNX}p") != 0) return(ES_Err::BAD_TEMPLATE);	//Ⴄev[ggp

	//̒o
	ClassInfoMap ciMap;
	const FCSheetManagerExp* pSheetMgr = (const FCSheetManagerExp*)FMpgGetMolipMain()->GetDocument()->GetSheetManager();
	FDSheetIDVector::const_iterator iSt;
	for(iSt = pSheetMgr->GetFreqSheetVector().begin();
		iSt != pSheetMgr->GetFreqSheetVector().end(); iSt++){
		FCLayerManagerExp* pLayerMgr = (FCLayerManagerExp*)pSheetMgr->GetSheet(*iSt);

		ObjBaseVector vObj;
		pLayerMgr->GetZOrder(vObj);
		ObjBaseVector::iterator iObj;

		//NX̒o
		for(iObj = vObj.begin(); iObj != vObj.end(); iObj++){
			ClassInfo ci;
			if(ExtractChipMaster(*iObj, ci)){
				ciMap.insert(ClassInfoMap_pair((*iObj)->GetObjID(), ci));
			}
		}

		//NXԂ̊֌W̒o
		for(iObj = vObj.begin(); iObj != vObj.end(); iObj++){
			//p𒊏o
			ExtractArrow(*iObj, ciMap);
		}
	}

	//eClassInfot@Cɏo
	return(write(ciMap, path));
}

/////////////////////////////////////////////////////////////////////////////////
//Ŏgp郁\bh

/*****************************************************************************/
/* NẌʒu<mdrwpos `>^O𐶐										 */
/*  ENTRY : FCObjectExp* pObj:^O쐬IuWFNg					 */
/*  RETURN: wstring			:ꂽ^O									 */
/*****************************************************************************/
wstring ExtractInfo::GetTag(const FCObjectExp* pObj)
{
	FCDocumentExp* pDoc = FMpgGetMolipMain()->GetDocument();
//	FCViewExp* pView = FMpgGetMolipMain()->GetView();
//	DBLRect mmrt;

	// r[SWZoB
//	pView->GetClientRectMM(mmrt);
//	DBLPoint mmpt = mmrt.CenterPoint();
	DBLPoint mmptF, mmptB;
	pObj->GetEdgePoint(mmptF, mmptB);
	CString strCenterX;
	CString strCenterY;
	// SWlAŕ쐬B
	strCenterX.Format(_T("%d"), (LONG)((mmptF.x+mmptB.x)/2));
	strCenterY.Format(_T("%d"), (LONG)((mmptF.y+mmptB.y)/2));
	CString strPos;
	strPos.Format(_T("<mdrwpos file=\"%s\" sheet=\"%ld\" cposx=\"%s\" cposy=\"%s\"/>"),
	    pDoc->GetPathName(), pDoc->GetCurrentSheetId(),
	    strCenterX, strCenterY);

	wstring r = TStrToWStr(strPos);
	return(r);
}

/*****************************************************************************/
/* sN`[IDƐ̎ނA[U[ID𐄒肷						 */
/* (ΉĂ̂TVĉATV̂)										 */
/*  ENTRY : FCObjectExp* pObj:^O쐬IuWFNg					 */
/*  RETURN: DWORD			:[U[ID										 */
/*****************************************************************************/
DWORD ExtractInfo::GetObjID(const FCObjectExp *pObj)
{
	DWORD ArrowID = 0, LineStyle = 0;

	//sN`[ID
	if(pObj->GetArrowBType() == FDUG_ARW_TYPE_PICT){
		FCObjectExp* pObjArwB = (FCObjectExp*)FMpgGetMolipMain()->GetEnv()->GetPictArrowRec(pObj->GetPictArrowB())->m_objpPictArrowMaster1;
		ArrowID = pObjArwB->GetObjUserUlong();	//id
	}
/*	if(pObj->GetArrowFType() == FDUG_ARW_TYPE_PICT){
		FCObjectExp* pObjArwF = (FCObjectExp*)FMpgGetMolipMain()->GetEnv()->GetPictArrowRec(pObj->GetPictArrowF())->m_objpPictArrowMaster1;
		ArrowID = pObjArwF->GetObjUserUlong();	//Oid
	}*/

	//̎
	const FCPenStyleRec* pStyleRec = FMpgGetMolipMain()->GetEnv()->GetPenStyleRec(pObj->GetStdPenStyle());
	if (pStyleRec->m_mmfaData[0] == 0 && pStyleRec->m_mmfaData[1] == 0 &&
		pStyleRec->m_mmfaData[2] == 0 && pStyleRec->m_mmfaData[3] == 0){
		LineStyle = 1;		//
	}else{
		LineStyle = 2;		//j
	}

	//sN`
	//1000 UML arrow
	//1001 UML generarization
	//1002 UML aggregation
	//1003 UML aggregation (painted)
	//1004 UML point

	//̎ނƃsN`[ID画
	if(ArrowID == 1001 && LineStyle == 1){
		return(9);	//TVĉ
	}
	if(ArrowID == 1001 && LineStyle == 2){
		return(10);	//TV
	}

	return(0);
}

/*****************************************************************************/
/* t@C݂邩ǂ`FbN									 */
/*  ENTRY :	const wstring &fnbase:`FbNpX+t@C				 */
/*  RETURN: BOOL			:TRUE=݂, FALSE=݂Ȃ				 */
/*****************************************************************************/
BOOL ExtractInfo::checkExistFile(const wstring &fn)
{
	HANDLE hFind;
	WIN32_FIND_DATAW fd;
	if((hFind=::FindFirstFileW(fn.c_str(), &fd)) != INVALID_HANDLE_VALUE){
		::FindClose(hFind);
		return(TRUE);	//łɑ݂
	}
	return(FALSE);		//݂Ȃ
}

/*****************************************************************************/
/* t@C㏑̏													 */
/*  ENTRY :	const wstring &fnbase:t@CۑpX+t@C			 */
/*  RETURN: BOOL			:TRUE=I, FALSE=ُI					 */
/*****************************************************************************/
BOOL ExtractInfo::onOverWrite(const wstring &fn)
{
/*
	//㏑mF
	wstring m = fn.substr(fn.rfind(L'\\')+1);
	m += L"͊ɑ݂܂\n㏑܂?";
	if(::MessageBoxW(FMpgGetMolipMain()->GetMainWindow(), m.c_str(), s_wcpComponentName, MB_YESNO | MB_ICONINFORMATION | MB_TOPMOST) != IDYES){
		//[]
		return(FALSE);;
	}
	return(TRUE);
*/
	//̃t@C*.bakɃl[(ł*.bakꍇ͍폜Ă)
	wstring old = fn;
	old += L".bak";

	if(checkExistFile(old.c_str())){
		//delete backup file
		if(!DeleteFileW(old.c_str())) return(FALSE);
	}
	//rename file
	if(!MoveFileW(fn.c_str(), old.c_str())) return(FALSE);

	return(TRUE);
}

/////////////////////////////////////////////////////////////////////////////////
//pŎgp郁\bh

/*****************************************************************************/
/* ChipMaster̃eLXgi̕𒊏o									 */
/*  ENTRY : FCObjectExp* pObj:oIuWFNg						 */
/*  RETURN: BOOL			:TRUE=, FALSE=s							 */
/*****************************************************************************/
BOOL ExtractInfo::ExtractChipMaster(FCObjectExp* pObj, ClassInfo& ci)
{
	FCObjBase **objBaseArray = pObj->GetMemberArray();
	DWORD cid;

//----test start
//x = pObj->GetObjID();
//----test end

	//exportΏۂ̕iǂmF
	if (pObj->Type() != FDOJ_CHIP_MASTER){
		return(FALSE);
	}
	// 2 SZNX
	// 3 SZۃNX
	// 4 SZC^[tFCXipj
	cid = pObj->GetObjUserUlong();
	if(cid != 2 && cid != 3 && cid != 4){
		return(FALSE);
	}

	//o
	for(int i = 0; i < pObj->GetMemberSize(); i++){
		const FCObjectExp* pObj_ = (const FCObjectExp*)objBaseArray[i];
		if(pObj_->GetRichText() != NULL){
			FCRichTextExp* pRT= (FCRichTextExp*)pObj_->GetRichText();
			wstring txt;

			switch(i){
			case 0:	//class name
				pRT->GetText(txt);
				ci.header.push_back(GetTag(pObj_));
				ci.setName(txt);
				break;
			case 1:	//property name
				if(cid == 4){
					//interface͑Ȃ
					ci.setOperation(pRT);
				}else{
					ci.setAttribute(pRT);
				}
				break;
			case 2:	//method name
				ci.setOperation(pRT);
				break;
			default:
				break;
			}
		}
	}
	return(TRUE);
}

/*****************************************************************************/
/* ̊֌W𒊏o															 */
/*  ENTRY : FCObjectExp* pObj:oIuWFNg						 */
/*			ClassInfoMap& ciMap:NX񂪊i[ꂽMapւ̎Q			 */
/*  RETURN: BOOL			:TRUE=, FALSE=s							 */
/*****************************************************************************/
BOOL ExtractInfo::ExtractArrow(FCObjectExp* pObj, ClassInfoMap& ciMap)
{
	//Ώۂ̕iǂmF
	if(pObj->Type() != FDOJ_POLY){
		return(FALSE);
	}
	// 9 TVĉ
	//10 TV
	DWORD cid = GetObjID(pObj);
	if(cid != 9 && cid != 10){
		return(FALSE);
	}

	//ON敔iid擾
	DWORD ObjIDF = 0, ObjIDT = 0;
	FCLinkRecPVector vAffected;
	FCLinkManagerExp* pLinkMgr = (FCLinkManagerExp*)FMpgGetMolipMain()->GetDocument()->LinkManager();
	pLinkMgr->GetAffectedByTo(vAffected,
								FCMolipRec(pObj->GetObjID(), 0));
	if(!vAffected.empty() && vAffected.size() == 1){
		ObjIDF = vAffected[0]->m_mlpFrom.dwObjID;
	}
	vAffected.clear();

	//ナN敔iid擾
	pLinkMgr->GetAffectedByTo(vAffected,
							FCMolipRec(pObj->GetObjID(),
									FCObjPoly::JointIDtoMolipID(pObj->GetJointSize() - 1)));
	if(!vAffected.empty() && vAffected.size() == 1){
		ObjIDT = vAffected[0]->m_mlpFrom.dwObjID;
	}

	if(ObjIDF == 0 || ObjIDT == 0){
		//ON敔iidナN敔iidݒ肳ĂȂ
		return(FALSE);
	}

	//OÑNXɌナÑNX
	ClassInfoMap::iterator cIterF = ciMap.find(ObjIDF);
	ClassInfoMap::iterator cIterT = ciMap.find(ObjIDT);
	if(cIterF == ciMap.end() || cIterT == ciMap.end()){
		//YNXȂ
		return(FALSE);
	}
	switch(cid){
	// 9 TVĉ
	case 9:
		(*cIterF).second.generalization.push_back((*cIterT).second.name.name);	//p
		break;
	//10 TV
	case 10:
		(*cIterF).second.realization.push_back((*cIterT).second.name.name);	//interface
		break;
	// 5 TV֘Aij
	// 6 TV֘Aij
	// 7 TB֘AiȐj
	// 8 TV֘Ai_j
	//11 TVˑ
	//12 TVW
	//13 TVW
	default:
		return(FALSE);	//ΏۊO̖
	}

	return(TRUE);
}

/*****************************************************************************/
/* \[X𐶐ăt@Cɏ (fnbase+NX+gq)		 */
/*  ENTRY :	ClassInfoMap &ciMap:NXmapւ̎Q						 */
/*			const wstring &fnbase:t@CۑpX					 */
/*  RETURN: ES_Err::code	:G[R[h									 */
/*****************************************************************************/
ES_Err::code ExtractInfo::write(ClassInfoMap &ciMap, const wstring &fnbase)
{
	ES_Err::code ret = ES_Err::SUCCESS;

	//eClassInfot@Cɏo
	ClassInfoMap::iterator ciIter;
	for(ciIter = ciMap.begin(); ciIter != ciMap.end(); ciIter++){
		//t@C𐶐(NX+gq)
		wstring fn;
		fn = (*ciIter).second.name.name;
		fn += GetFileExt();

		//\[Xwb_ɋʂŏo͂
		(*ciIter).second.header.push_back(L"");
		(*ciIter).second.header.push_back(fn);
		wstring t = L" (generated by ";
		t += s_wcpComponentName;
		t += L" ";
		t += s_wcpComponentVersion;
		t += L")";
		(*ciIter).second.header.push_back(t);
		(*ciIter).second.header.push_back(L"");

		//\[X𐶐
		if(!makeSource((*ciIter).second)){
			ret = ES_Err::SOURCEGENERATION_FAILED;
			continue;		//Ɏsꍇ͏݂XLbv
		}

		//tpX+t@C
		wstring filename = fnbase + fn;

		//㏑`FbNƊmF
		if(checkExistFile(filename)){
			if(!onOverWrite(filename)){
				ret = ES_Err::OVERWRITE_ABORTED;
				continue;	//㏑LZꍇ͏݂XLbv
			}
		}

		//t@Cɏ
		ES_Err::code cd = (*ciIter).second.write(filename);
		if(cd != ES_Err::SUCCESS) return(cd);	//݂Ɏsꍇ͑A
	}
	return(ret);
}
