<?php
/**
@brief 񤭹ߤ򤷤᤹ DataObject ե
@author minahito
@version $Id: blog.php,v 1.7 2004/10/07 10:02:31 minahito Exp $
*/

require_once "xoops/class.object.php";
require_once "xoops/user.php";

class xixiBlogBlogObject extends exXoopsObject
{
	var $head_=null;

	function xixiBlogBlogObject($id=null)
	{
		$this->initVar('id', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('uid', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('input_date', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('title', XOBJ_DTYPE_TXTBOX, null, true, 255);
		$this->initVar('contents', XOBJ_DTYPE_TXTAREA, null, true, null);

		if(is_array($id))
			$this->assignVars($id);
	}

	function &getStructure($type='s')
	{
		$ret =& parent::getStructure($type);

   		$uHandler=&xoops_gethandler('user');
   		$user = new exXoopsUserObject($uHandler->get($this->getVar('uid')));
   		$ret['user']=$user->getArray($type);

		if($this->head_!==null)
			$ret['head']=$this->head_->getStructure();

		$handler=&xixiBlog::getHandler('comment');
		$ret['comment_count']=$handler->getCount(new Criteria("id",$this->getVar('id')));

		$handler=&xixiBlog::getHandler('trackback');
		$ret['trackback_count']=$handler->getCount(new Criteria("id",$this->getVar('id')));
		
		$ret['blog_name']=@sprintf(_MD_XIXIBLOG_BLOG_NAME,$ret['user']['uname']);

		return $ret;
	}

	function &getShortStructure($type='s',$length=512)
	{
		$ret = &$this->getStructure($type);

		if($length>0) {
    		// åû̽
    		$contents = $this->getVar('contents');
    		if (XOOPS_USE_MULTIBYTES == 1 && function_exists('mb_internal_encoding') && @mb_internal_encoding(_CHARSET)) {
    			$str2 = mb_strcut( $contents , 0, $length - strlen( "..." ) );
    			$ret['contents'] = $str2.( mb_strlen($contents)!=mb_strlen($str2) ? "..." : '' );
    		}
    		else
    			$ret['contents'] = substr($contents, 0, $length - strlen("..."))."...";
		}
		return $ret;
	}

	// إåɤ߹
	function loadHead()
	{
		$handler=&xixiBlog::getHandler('head');
		$this->head_=$handler->get($this->getVar('uid'));
		if(!is_object($this->head_))
			$this->head_=$handler->create();
	}

	/**
	Υ֥Ȥȥǡ١Ȥ³ˡ֤
	*/
	function &getTableInfo()
	{
		$tinfo = new exTableInfomation('xixiblog_blog','id');
		return ($tinfo);
	}
}

?>