<?php
/**
@file
@brief ֥ѥåե륿
@version $Id: BlogFilter.php,v 1.2 2004/08/09 11:34:36 minahito Exp $
*/

require_once "exForm/Filter.php";

/**
@brief UID ɬפȤʤ Filter
*/
class xixiBlogGlobalFilter extends exAbstractFilterForm
{
	function getCriteria($start=0,$limit=0,$sort=0)
	{
		return $this->getDefaultCriteria($start,$limit);
	}

	function getDefaultCriteria($start=0,$limit=0)
	{
		$criteria = new CriteriaCompo();

		$criteria->setSort('input_date');
		$criteria->setOrder('DESC');
		$criteria->setStart($start);
		$criteria->setLimit($limit);
		
		return ($criteria);
	}
}

/**
@brief UID ǤʤФʤե륿
*/
class xixiBlogFilter extends xixiBlogGlobalFilter {
	var $uid_=null;
	
	function fetch()
	{
		$this->uid_=$this->getPositiveIntger('uid');
	}

	function getCriteria($start=0,$limit=0)
	{
		if($this->uid_>0) {
			$criteria = $this->getDefaultCriteria($start,$limit);
			$criteria->add(new Criteria('uid',$this->uid_));
			return $criteria;
		}
		else {
			// 顼ˤʤ criteria ֤
			$this->msg_[]="REQUEST ERROR";
			return null;
		}
	}

	function getExtra()
	{
		return array("uid"=>$this->uid_);
	}
}

/**
@brief UID+DATE ǤʤФʤե륿ѡ
*/
class xixiBlogDayFilter extends xixiBlogFilter {
	var $date_=0;
	
	function fetch()
	{
		parent::fetch();
		$this->date_=$this->getPositiveIntger('date');
	}

	function getCriteria($start=0,$limit=0)
	{
		if($this->uid_>0 && $this->date_) {
			$criteria = $this->getDefaultCriteria($start,$limit);
			$criteria->add(new Criteria('uid',$this->uid_));
			$criteria->add(new Criteria('input_date',$this->date_,">="));
			$criteria->add(new Criteria('input_date',$this->date_+24*3600,"<="));
			return $criteria;
		}
		else {
			// 顼ˤʤ criteria ֤
			$this->msg_[]="REQUEST ERROR";
			return null;
		}
	}

	function getExtra()
	{
		$ret=parent::getExtra();
		$ret['date']=$this->date_;
		return $ret;
	}
}

/**
@brief UID+DATE ǤʤФʤե륿ʷѡ
*/
class xixiBlogMonthFilter extends xixiBlogDayFilter {

	function getCriteria($start=0,$limit=0)
	{
		if($this->uid_>0 && $this->date_) {
			$criteria = $this->getDefaultCriteria($start,$limit);
			$criteria->add(new Criteria('uid',$this->uid_));
			$criteria->add(new Criteria('input_date',$this->date_,">="));

			$year=date('Y',$this->date_);
			$month=date('m',$this->date_);
			$month++;
			if($month>12) {
				$year++;
				$month=1;
			}

			$criteria->add(new Criteria('input_date',mktime(0,0,0,$month,1,$year),'<='));
			
			return $criteria;
		}
		else {
			// 顼ˤʤ criteria ֤
			$this->msg_[]="REQUEST ERROR";
			return null;
		}
	}
}

?>
