/*
 * Copyright, 2009 Koichi Takahashi. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.nec.exi.editor.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

import com.nec.exi.editor.Resources;

/**
 * @author Koichi Takahashi
 */
public class NewFilePage extends WizardNewFileCreationPage {
	
	public NewFilePage(IStructuredSelection selection) {
		super(Resources.get("NewFilePage.0"), selection);   //$NON-NLS-1$
		setTitle(Resources.get("NewFilePage.1"));   //$NON-NLS-1$
		setDescription(Resources.get("NewFilePage.2"));   //$NON-NLS-1$
		setFileName("tmp.exi");  //$NON-NLS-1$
	}
	
	protected boolean validatePage() {
		boolean valid = super.validatePage();
		if(valid){
			if(!getFileName().endsWith(".exi")){  //$NON-NLS-1$
				setMessage(Resources.get("NewFilePage.3"), ERROR);   //$NON-NLS-1$
				return false;
			}
		}
		return valid;
	}
	
}