/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.http2.parser.RateControl;

public class WindowRateControl
implements RateControl {
    private final Queue<Long> events = new ConcurrentLinkedQueue<Long>();
    private final AtomicInteger size = new AtomicInteger();
    private final int maxEvents;
    private final long window;

    public WindowRateControl(int maxEvents, Duration window) {
        this.maxEvents = maxEvents;
        this.window = window.toNanos();
    }

    @Override
    public boolean onEvent(Object event) {
        Long time;
        long now = System.nanoTime();
        while ((time = this.events.peek()) != null && now >= time) {
            if (!this.events.remove(time)) continue;
            this.size.decrementAndGet();
        }
        this.events.add(now + this.window);
        return this.size.incrementAndGet() <= this.maxEvents;
    }
}

