// $Id: mod_zlib.cpp,v 1.6 2003/10/30 10:18:57 yuya Exp $

#include <windows.h>
#include <ruby.h>
#include <zlib.h>
#include "mod_zlib.h"
#include "plugin.h"

////////////////////////////////////////////////////////////////////////////////

static VALUE rb_eExerbRuntimeError = 0;

////////////////////////////////////////////////////////////////////////////////

#ifndef EXERB_RUNTIMELIB
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved);
#endif

static void mod_zlib_decompress(char *decompressed, DWORD size_of_decompressed, char *compressed, DWORD size_of_compressed);

////////////////////////////////////////////////////////////////////////////////

#ifndef EXERB_RUNTIMELIB
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	if ( fdwReason == DLL_PROCESS_ATTACH ) {
		mod_zlib_init();
	}
	
	return TRUE;
}
#endif

void
mod_zlib_init()
{
	rb_eExerbRuntimeError = *((DWORD*)::GetProcAddress(::GetModuleHandle(NULL), "rb_eExerbRuntimeError"));
	::exerb_add_plugin_function(MOD_ZLIB_DECOMPRESS_NAME, (PLUGIN_PROC)mod_zlib_decompress);
}

static void
mod_zlib_decompress(char *decompressed, DWORD size_of_decompressed, char *compressed, DWORD size_of_compressed)
{
	int ret = ::uncompress((BYTE*)decompressed, &size_of_decompressed, (BYTE*)compressed, size_of_compressed);
	if ( ret ) ::rb_raise(rb_eExerbRuntimeError, "Couldn't decompress the data.");
}

////////////////////////////////////////////////////////////////////////////////
