
#==============================================================================#
# $Id: image_resource_directory.rb,v 1.2 2003/11/18 16:46:19 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class ImageResourceDirectory < Base

        FORMAT = 'LLSSSS'

        def initialize
          super()
          @characteristics        = nil
          @time_date_stamp        = nil
          @major_version          = nil
          @minor_version          = nil
          @number_of_name_entries = nil
          @number_of_id_entries   = nil
        end

        attr_accessor :characteristics, :time_date_stamp, :major_version, :minor_version, :number_of_name_entries, :number_of_id_entries

        def pack
          return [@characteristics, @time_date_stamp, @major_version, @minor_version, @number_of_name_entries, @number_of_id_entries].pack(FORMAT)
        end

        def unpack(bin)
          @characteristics, @time_date_stamp, @major_version, @minor_version, @number_of_name_entries, @number_of_id_entries = bin.unpack(FORMAT)
          return self
        end

      end # ImageResourceDirectory

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
