
#==============================================================================#
# $Id: image_file_header.rb,v 1.1 2003/11/22 18:39:19 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class ImageFileHeader < Base

        FORMAT = 'SSLLLSS'

        def initialize
          @machine                 = nil
          @number_of_sections      = nil
          @time_date_stamp         = nil
          @pointer_to_symbol_table = nil
          @number_of_symbols       = nil
          @size_of_optional_header = nil
          @characteristics         = nil
        end

        attr_accessor :machine, :number_of_sections, :time_date_stamp, :pointer_to_symbol_table, :number_of_symbols, :size_of_optional_header, :characteristics

        def pack
          return [@machine, @number_of_sections, @time_date_stamp, @pointer_to_symbol_table, @number_of_symbols, @size_of_optional_header, @characteristics].pack(FORMAT)
        end

        def unpack(bin)
          @machine, @number_of_sections, @time_date_stamp, @pointer_to_symbol_table, @number_of_symbols, @size_of_optional_header, @characteristics = bin.unpack(FORMAT)
          return self
        end

      end # ImageFileHeader

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
