
#==============================================================================#
# $Id: icon_res_entry.rb,v 1.1 2003/11/22 23:21:43 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class IconResEntry < Base

        FORMAT = 'CCCCSSLS'

        def initialize
          @width        = nil
          @height       = nil
          @color_count  = nil
          @reserved     = nil
          @planes       = nil
          @bit_count    = nil
          @bytes_in_res = nil
          @image_offset = nil
        end

        attr_accessor :width, :height, :color_count, :reserved, :planes, :bit_count, :bytes_in_res, :image_offset

        def pack
          return [@width, @height, @color_count, @reserved, @planes, @bit_count, @bytes_in_res, @image_offset].pack(FORMAT)
        end

        def unpack(bin)
          @width, @height, @color_count, @reserved, @planes, @bit_count, @bytes_in_res, @image_offset = bin.unpack(FORMAT)
          return self
        end

      end # IconResEntry

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
