// $Id: BRbStringTable.h,v 1.5 2002/12/13 08:39:45 yuya Exp $

#ifndef _BRbStringTable_h_
#define _BRbStringTable_h_

////////////////////////////////////////////////////////////////////////////////

#include <vector>
#include "BRbBase.h"
#include "BRbOutputBuffer.h"
#include "BRbInputBuffer.h"
#include "BRbDebug.h"

////////////////////////////////////////////////////////////////////////////////

typedef struct {
	word  len;
	char* str;
} STRITEM;

////////////////////////////////////////////////////////////////////////////////

class BRbStringTable
{

public:
	BRbStringTable(BRbDebug& debug);
	virtual ~BRbStringTable();

public:
	virtual word set(const char* str);
	virtual word set(const char* str, word len);
	virtual const char* get(word idx);
	virtual const char* get(word idx, word* len);

	virtual void clear();
	virtual void dump(BRbOutputBuffer& buffer);
	virtual void load(BRbInputBuffer& buffer);

protected:
	std::vector<STRITEM*> m_table;
	BRbDebug& m_debug;

};

////////////////////////////////////////////////////////////////////////////////

#endif

////////////////////////////////////////////////////////////////////////////////
