
#==============================================================================#
# $Id: image_nt_headers32.rb,v 1.2 2003/11/28 09:39:38 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'
require 'exerb/win32/struct/image_file_header'
require 'exerb/win32/struct/image_optional_header32'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class ImageNtHeaders32 < Base

        SIGNATURE = 0x00004550

        def initialize
          @signature       = nil
          @file_header     = nil
          @optional_header = nil
        end

        attr_accessor :signature, :file_header, :optional_header

        def pack
          return [signature].pack('L') + @file_header.pack + @optional_header.pack
        end

        def unpack
          raise NotImplementedError
        end

        def read(io)
          @position        = io.pos
          @signature       = io.read(4).unpack('L')[0]
          raise('nt headers have invalid signature') unless @signature == SIGNATURE
          @file_header     = ImageFileHeader.read(io)
          @optional_header = ImageOptionalHeader32.read(io)
          return self
        end

      end # ImageNtHeaders32

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
