// $Id: BRb.h,v 1.6 2003/01/15 15:29:56 yuya Exp $

#ifndef _BRb_h_
#define _BRb_h_

////////////////////////////////////////////////////////////////////////////////

#include "BRbBase.h"
#include "BRbInputBuffer.h"
#include "BRbOutputBuffer.h"
#include "BRbReadNode.h"
#include "BRbWriteNode.h"
#include "BRbDebug.h"

////////////////////////////////////////////////////////////////////////////////

class BRb
{

private:
	BRb();
	virtual ~BRb();

public:
	static VALUE readfile(VALUE filename);
#ifdef BRB_WRITER
	static NODE* compile(VALUE code, VALUE filename);
	static VALUE dumpnode(NODE* node, bool debugflag, VALUE exception);
	static VALUE dumpcode(VALUE code, VALUE filename, bool debugflag, VALUE exception);
	static VALUE dumpfile(VALUE filename, bool debugflag, VALUE exception);
#endif
#ifdef BRB_READER
	static NODE* loadnode(VALUE code, VALUE filename, bool debugflag, VALUE exception);
	static VALUE loadcode(VALUE code, VALUE filename, bool debugflag, VALUE exception);
	static VALUE loadfile(VALUE filename, bool debugflag, VALUE exception);
#endif
#if defined(BRB_WRITER) && defined(BRB_READER)
	static bool verifycode(VALUE code, VALUE filename, bool debugflag, VALUE exception);
	static bool verifyfile(VALUE filename, bool debugflag, VALUE exception);
#endif

};

////////////////////////////////////////////////////////////////////////////////

#endif

////////////////////////////////////////////////////////////////////////////////
