
#==============================================================================#
# $Id: image_optional_header32.rb,v 1.3 2003/11/22 21:54:01 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class ImageOptionalHeader32 < Base

        FORMAT = 'SCCLLLLLLLLLSSSSSSLLLLSSLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL'

        def initialize
          @magic
          @major_linker_version             = nil
          @minor_linker_version             = nil
          @size_of_code                     = nil
          @size_of_initialized_data         = nil
          @size_of_uninitialized_data       = nil
          @address_of_entry_point           = nil
          @base_of_code                     = nil
          @base_of_data                     = nil
          @image_base                       = nil
          @section_alignment                = nil
          @file_alignment                   = nil
          @major_operating_system_version   = nil
          @minor_operating_system_version   = nil
          @major_image_version              = nil
          @minor_image_version              = nil
          @major_subsystem_version          = nil
          @minor_subsystem_version          = nil
          @win32_version_value              = nil
          @size_of_image                    = nil
          @size_of_headers                  = nil
          @checksum                         = nil
          @subsystem                        = nil
          @dll_characteristics              = nil
          @size_of_stack_reserve            = nil
          @size_of_stack_commit             = nil
          @size_of_heap_reserve             = nil
          @size_of_heap_commit              = nil
          @loader_flags                     = nil
          @number_of_rva_and_sizes          = nil
          @data_directory0_virtual_address  = nil
          @data_directory0_virtual_size     = nil
          @data_directory1_virtual_address  = nil
          @data_directory1_virtual_size     = nil
          @data_directory2_virtual_address  = nil
          @data_directory2_virtual_size     = nil
          @data_directory3_virtual_address  = nil
          @data_directory3_virtual_size     = nil
          @data_directory4_virtual_address  = nil
          @data_directory4_virtual_size     = nil
          @data_directory5_virtual_address  = nil
          @data_directory5_virtual_size     = nil
          @data_directory6_virtual_address  = nil
          @data_directory6_virtual_size     = nil
          @data_directory7_virtual_address  = nil
          @data_directory7_virtual_size     = nil
          @data_directory8_virtual_address  = nil
          @data_directory8_virtual_size     = nil
          @data_directory9_virtual_address  = nil
          @data_directory9_virtual_size     = nil
          @data_directory10_virtual_address = nil
          @data_directory10_virtual_size    = nil
          @data_directory11_virtual_address = nil
          @data_directory11_virtual_size    = nil
          @data_directory12_virtual_address = nil
          @data_directory12_virtual_size    = nil
          @data_directory13_virtual_address = nil
          @data_directory13_virtual_size    = nil
          @data_directory14_virtual_address = nil
          @data_directory14_virtual_size    = nil
          @data_directory15_virtual_address = nil
          @data_directory15_virtual_size    = nil
        end

        attr_accessor :magic, :major_linker_version, :minor_linker_version, :size_of_code, :size_of_initialized_data, :size_of_uninitialized_data, :address_of_entry_point, :base_of_code, :base_of_data, :image_base, :section_alignment, :file_alignment, :major_operating_system_version, :minor_operating_system_version, :major_image_version, :minor_image_version, :major_subsystem_version, :minor_subsystem_version, :win32_version_value, :size_of_image, :size_of_headers, :checksum, :subsystem, :dll_characteristics, :size_of_stack_reserve, :size_of_stack_commit, :size_of_heap_reserve, :size_of_heap_commit, :loader_flags, :number_of_rva_and_sizes, :data_directory0_virtual_address, :data_directory0_virtual_size, :data_directory1_virtual_address, :data_directory1_virtual_size, :data_directory2_virtual_address, :data_directory2_virtual_size, :data_directory3_virtual_address, :data_directory3_virtual_size, :data_directory4_virtual_address, :data_directory4_virtual_size, :data_directory5_virtual_address, :data_directory5_virtual_size, :data_directory6_virtual_address, :data_directory6_virtual_size, :data_directory7_virtual_address, :data_directory7_virtual_size, :data_directory8_virtual_address, :data_directory8_virtual_size, :data_directory9_virtual_address, :data_directory9_virtual_size, :data_directory10_virtual_address, :data_directory10_virtual_size, :data_directory11_virtual_address, :data_directory11_virtual_size, :data_directory12_virtual_address, :data_directory12_virtual_size, :data_directory13_virtual_address, :data_directory13_virtual_size, :data_directory14_virtual_address, :data_directory14_virtual_size, :data_directory15_virtual_address, :data_directory15_virtual_size

        def pack
          return [@magic, @major_linker_version, @minor_linker_version, @size_of_code, @size_of_initialized_data, @size_of_uninitialized_data, @address_of_entry_point, @base_of_code, @base_of_data, @image_base, @section_alignment, @file_alignment, @major_operating_system_version, @minor_operating_system_version, @major_image_version, @minor_image_version, @major_subsystem_version, @minor_subsystem_version, @win32_version_value, @size_of_image, @size_of_headers, @checksum, @subsystem, @dll_characteristics, @size_of_stack_reserve, @size_of_stack_commit, @size_of_heap_reserve, @size_of_heap_commit, @loader_flags, @number_of_rva_and_sizes, @data_directory0_virtual_address, @data_directory0_virtual_size, @data_directory1_virtual_address, @data_directory1_virtual_size, @data_directory2_virtual_address, @data_directory2_virtual_size, @data_directory3_virtual_address, @data_directory3_virtual_size, @data_directory4_virtual_address, @data_directory4_virtual_size, @data_directory5_virtual_address, @data_directory5_virtual_size, @data_directory6_virtual_address, @data_directory6_virtual_size, @data_directory7_virtual_address, @data_directory7_virtual_size, @data_directory8_virtual_address, @data_directory8_virtual_size, @data_directory9_virtual_address, @data_directory9_virtual_size, @data_directory10_virtual_address, @data_directory10_virtual_size, @data_directory11_virtual_address, @data_directory11_virtual_size, @data_directory12_virtual_address, @data_directory12_virtual_size, @data_directory13_virtual_address, @data_directory13_virtual_size, @data_directory14_virtual_address, @data_directory14_virtual_size, @data_directory15_virtual_address, @data_directory15_virtual_size].pack(FORMAT)
        end

        def unpack(bin)
          @magic, @major_linker_version, @minor_linker_version, @size_of_code, @size_of_initialized_data, @size_of_uninitialized_data, @address_of_entry_point, @base_of_code, @base_of_data, @image_base, @section_alignment, @file_alignment, @major_operating_system_version, @minor_operating_system_version, @major_image_version, @minor_image_version, @major_subsystem_version, @minor_subsystem_version, @win32_version_value, @size_of_image, @size_of_headers, @checksum, @subsystem, @dll_characteristics, @size_of_stack_reserve, @size_of_stack_commit, @size_of_heap_reserve, @size_of_heap_commit, @loader_flags, @number_of_rva_and_sizes, @data_directory0_virtual_address, @data_directory0_virtual_size, @data_directory1_virtual_address, @data_directory1_virtual_size, @data_directory2_virtual_address, @data_directory2_virtual_size, @data_directory3_virtual_address, @data_directory3_virtual_size, @data_directory4_virtual_address, @data_directory4_virtual_size, @data_directory5_virtual_address, @data_directory5_virtual_size, @data_directory6_virtual_address, @data_directory6_virtual_size, @data_directory7_virtual_address, @data_directory7_virtual_size, @data_directory8_virtual_address, @data_directory8_virtual_size, @data_directory9_virtual_address, @data_directory9_virtual_size, @data_directory10_virtual_address, @data_directory10_virtual_size, @data_directory11_virtual_address, @data_directory11_virtual_size, @data_directory12_virtual_address, @data_directory12_virtual_size, @data_directory13_virtual_address, @data_directory13_virtual_size, @data_directory14_virtual_address, @data_directory14_virtual_size, @data_directory15_virtual_address, @data_directory15_virtual_size = bin.unpack(FORMAT)
          return self
        end

        alias :resource_directory_virtual_address  :data_directory2_virtual_address
        alias :resource_directory_virtual_address= :data_directory2_virtual_address=
        alias :resource_directory_virtual_size  :data_directory2_virtual_size
        alias :resource_directory_virtual_size= :data_directory2_virtual_size=

      end # ImageOptionalHeader32

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
