
#==============================================================================#
# $Id: icon_header.rb,v 1.1 2003/11/21 20:14:58 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class IconHeader < Base

        FORMAT = 'SSS'

        def initialize
          @reserved = nil
          @type     = nil
          @count    = nil
        end

        attr_accessor :reserved, :type, :count

        def pack
          return [@reserved, @type, @count].pack(FORMAT)
        end

        def unpack(bin)
          @reserved, @type, @count = bin.unpack(FORMAT)
          return self
        end

      end # IconHeader

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
