
#==============================================================================#
# $Id: file_table.rb,v 1.9 2003/11/17 17:45:49 yuya Exp $
#==============================================================================#

require 'exerb/utility'

#==============================================================================#

module Exerb

  class FileTable

    def initialize
      @entries  = []
    end

    def add(id, data, type)
      @entries << Entry.new(id, data, type)
      return @entries.last
    end

    def add_from_file(id, path, type)
      return File.open(path, 'rb') { |file| self.add(id, file.read, type) }
    end

    def add_ruby_script(id, data)
      return self.add(id, data, Entry::TYPE_RUBY_SCRIPT)
    end

    def add_ruby_script_from_file(id, path)
      return self.add_from_file(id, path, Entry::TYPE_RUBY_SCRIPT)
    end

    def add_bruby_binary(id, data)
      return self.add(id, data, Entry::TYPE_BRUBY_BINARY)
    end

    def add_bruby_binary_from_file(id, path)
      return self.add_from_file(id, path, Entry::TYPE_BRUBY_BINARY)
    end

    def add_extension_library(id, data)
      return self.add(id, data, Entry::TYPE_EXTENSION_LIBRARY)
    end

    def add_extension_library_from_file(id, path)
      return self.add_from_file(id, path, Entry::TYPE_EXTENSION_LIBRARY)
    end

    def add_dynamic_library(id, data)
      return self.add(id, data, Entry::TYPE_DYNAMIC_LIBRARY)
    end

    def add_dynamic_library_from_file(id, path)
      return self.add_from_file(id, path, Entry::TYPE_DYNAMIC_LIBRARY)
    end

    def add_resource_library(id, data)
      return self.add(id, data, Entry::TYPE_RESOURCE_LIBRARY)
    end

    def add_resource_library_from_file(id, path)
      return self.add_from_file(id, path, Entry::TYPE_RESOURCE_LIBRARY)
    end

    def add_data_binary(id, data)
      return self.add(id, data, Entry::TYPE_DATA_BINARY)
    end

    def add_data_binary_from_file(id, path)
      return self.add_from_file(id, path, Entry::TYPE_DATA_BINARY)
    end

    def pack
      headers = ''
      pool    = ''

      @entries.each { |entry|
        headers << entry.pack_header(pool)
        pool    << entry.pack_pool
      }

      packed_headers = Utility.alignment16(headers)
      packed_pool    = Utility.alignment16(pool)

      table_header = FileTableHeader.new
      table_header.signature         = FileTableHeader::SIGNATURE
      table_header.number_of_headers = @entries.size
      table_header.offset_of_headers = Utility.alignment16(table_header.pack).size
      table_header.offset_of_pool    = table_header.offset_of_headers + packed_headers.size

      return Utility.alignment16(table_header.pack) + packed_headers + packed_pool
    end

    class Entry

      TYPE_RUBY_SCRIPT       = 1
      TYPE_BRUBY_BINARY      = 2
      TYPE_EXTENSION_LIBRARY = 3
      TYPE_DYNAMIC_LIBRARY   = 4
      TYPE_RESOURCE_LIBRARY  = 5
      TYPE_DATA_BINARY       = 6

      def initialize(id, data, type)
        @id   = id
        @data = data
        @type = type
      end

      attr_reader :id, :data, :type

      def pack_header(pool)
        entry_header = FileEntryHeader.new
        entry_header.id             = @id
        entry_header.offset_of_file = pool.size
        entry_header.size_of_file   = @data.size
        entry_header.type_of_file   = @type

        return entry_header.pack
      end

      def pack_pool
        return Utility.alignment16(@data)
      end

    end # Entry

  end # FileTabel

  class FileTableHeader

    SIGNATURE = 0x02005446

    def initialize
      @signature         = nil
      @number_of_headers = nil
      @offset_of_headers = nil
      @offset_of_pool    = nil
    end

    attr_accessor :signature, :number_of_headers, :offset_of_headers, :offset_of_pool

    def pack
      return [@signature, @number_of_headers, @offset_of_headers, @offset_of_pool].pack('LSLL')
    end

  end # FileTableHeader

  class FileEntryHeader

    def initialize
      @id             = nil
      @offset_of_file = nil
      @size_of_file   = nil
      @type_of_file   = nil
    end

    attr_accessor :id, :offset_of_file, :size_of_file, :type_of_file

    def pack
      return [@id, @offset_of_file, @size_of_file, @type_of_file].pack('SLLC')
    end

  end # FileEntryHeader

end # Exerb

#==============================================================================#
#==============================================================================#
