// $Id: utility.cpp,v 1.12 2003/11/14 14:07:32 yuya Exp $

#include <windows.h>
#include <ruby.h>
#include "exerb.h"
#include "utility.h"

////////////////////////////////////////////////////////////////////////////////

extern VALUE rb_eExerbRuntimeError;

extern NAME_TABLE_HEADER *g_name_table_header;
extern FILE_TABLE_HEADER *g_file_table_header;

////////////////////////////////////////////////////////////////////////////////

char*
exerb_strdup(const char* str)
{
	if ( str == NULL ) return NULL;

	char *newstr = new char[::strlen(str) + 1];
	::strcpy(newstr, str);

	return newstr;
}

HANDLE
exerb_fopen_for_read(char *filepath)
{
	HANDLE file = ::CreateFile(filepath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
	if ( file == INVALID_HANDLE_VALUE ) ::exerb_raise_runtime_error(::GetLastError());

	return file;
}

HANDLE
exerb_fopen_for_write(char *filepath)
{
	HANDLE file = ::CreateFile(filepath, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, NULL, NULL);
	if ( file == INVALID_HANDLE_VALUE ) ::exerb_raise_runtime_error(::GetLastError());

	return file;
}

BOOL
exerb_fclose(HANDLE file)
{
	BOOL ret = ::CloseHandle(file);
	if ( !ret ) ::exerb_raise_runtime_error(::GetLastError());

	return ret;
}

DWORD
exerb_fseek(HANDLE file, LONG pos, DWORD method)
{
	DWORD ret = ::SetFilePointer(file, pos, NULL, method);
	//if ( ret == INVALID_SET_FILE_POINTER ) ::exerb_raise_runtime_error(::GetLastError())

	return ret;
}

DWORD
exerb_fread(HANDLE file, void *buffer, int size)
{
	DWORD read_size = 0;
	BOOL  ret = ::ReadFile(file, buffer, size, &read_size, NULL);
	if ( !ret ) {
		DWORD error = ::GetLastError();
		::CloseHandle(file);
		::exerb_raise_runtime_error(error);
	}

	return read_size;
}

DWORD
exerb_fwrite(HANDLE file, void *buffer, int size)
{
	DWORD written = 0;
	BOOL ret = ::WriteFile(file, buffer, size, &written, NULL);
	if ( !ret ) {
		DWORD error = ::GetLastError();
		::CloseHandle(file);
		::exerb_raise_runtime_error(error);
	}

	return written;
}

DWORD
exerb_fsize(HANDLE file)
{
	DWORD size = ::GetFileSize(file, NULL);
	if ( size == (DWORD)-1 ) {
		DWORD error = ::GetLastError();
		::CloseHandle(file);
		::exerb_raise_runtime_error(error);
	}

	return size;
}

char*
exerb_get_module_filepath(HMODULE handle, char *filepath, int size)
{
	DWORD ret = ::GetModuleFileName(handle, filepath, size);
	if ( !ret ) ::exerb_raise_runtime_error(::GetLastError());

	return ::exerb_get_filename(filepath);
}

char*
exerb_get_self_filepath(char *filepath, int size)
{
	return ::exerb_get_module_filepath(NULL, filepath, size);
}

char*
exerb_get_filename(char *filepath)
{
	char *filename = NULL;
	if ( filename = ::strrchr(filepath, '\\') ) return filename + 1;
	if ( filename = ::strrchr(filepath, '/')  ) return filename + 1;

	return filepath;
}

void
exerb_raise_runtime_error(DWORD error_no)
{
	// insecure
	char message0[1024] = "";
	char message1[1024 + 128] = "";
	::FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, error_no, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), message0, sizeof(message0), NULL);
	::sprintf(message1, "Win32API Error #%i --- %s", error_no, message0);
	::rb_raise(rb_eExerbRuntimeError, message1);
}

NAME_ENTRY_HEADER*
exerb_find_name_entry(WORD id)
{
	NAME_ENTRY_HEADER *name_entry = GET_FIRST_NAME_ENTRY(g_name_table_header);

	for ( int i = 0; i < g_name_table_header->number_of_headers; i++, name_entry++ ) {
		if ( name_entry->id == id ) {
			return name_entry;
		}
	}

	return NULL;
}

NAME_ENTRY_HEADER*
exerb_find_name_entry(char *filename)
{
	NAME_ENTRY_HEADER *name_entry = GET_FIRST_NAME_ENTRY(g_name_table_header);

	for ( int i = 0; i < g_name_table_header->number_of_headers; i++, name_entry++ ) {
		if ( ::stricmp(GET_NAME_FROM_ENTRY_HEADER(g_name_table_header, name_entry), filename) == 0 ) {
			return name_entry;
		}
	}

	return NULL;
}

FILE_ENTRY_HEADER*
exerb_find_file_entry(WORD id)
{
	FILE_ENTRY_HEADER *file_entry = GET_FIRST_FILE_ENTRY(g_file_table_header);

	for ( int i = 0; i < g_file_table_header->number_of_headers; i++, file_entry++ ) {
		if ( file_entry->id == id ) {
			return file_entry;
		}
	}

	return NULL;
}

////////////////////////////////////////////////////////////////////////////////
