
#==============================================================================#
# $Id: image_dos_header.rb,v 1.1 2003/11/22 18:39:19 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class ImageDosHeader < Base

        FORMAT = 'SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSL'

        def initialize
          @magic                       = nil
          @last_page_size              = nil
          @total_pages_in_file         = nil
          @relocation_items            = nil
          @paragraphs_in_header        = nil
          @minimum_extra_paragraphs    = nil
          @maximum_extra_paragraphs    = nil
          @initial_stack_segment       = nil
          @initial_stack_pointer       = nil
          @complemented_checksum       = nil
          @initial_instraction_pointer = nil
          @initial_code_segment        = nil
          @relocation_table_offset     = nil
          @overlay_number              = nil
          @reserved1_1                 = nil
          @reserved1_2                 = nil
          @reserved1_3                 = nil
          @reserved1_4                 = nil
          @oem_identifier              = nil
          @oem_information             = nil
          @reserved2_1                 = nil
          @reserved2_2                 = nil
          @reserved2_3                 = nil
          @reserved2_4                 = nil
          @reserved2_5                 = nil
          @reserved2_6                 = nil
          @reserved2_7                 = nil
          @reserved2_8                 = nil
          @reserved2_9                 = nil
          @reserved2_10                = nil
          @offset_to_new_header        = nil
        end

        attr_accessor :magic, :last_page_size, :total_pages_in_file, :relocation_items, :paragraphs_in_header, :minimum_extra_paragraphs, :maximum_extra_paragraphs, :initial_stack_segment, :initial_stack_pointer, :complemented_checksum, :initial_instraction_pointer, :initial_code_segment, :relocation_table_offset, :overlay_number, :reserved1_1, :reserved1_2, :reserved1_3, :reserved1_4, :oem_identifier, :oem_information, :reserved2_1, :reserved2_2, :reserved2_3, :reserved2_4, :reserved2_5, :reserved2_6, :reserved2_7, :reserved2_8, :reserved2_9, :reserved2_10, :offset_to_new_header

        def pack
          return [@magic, @last_page_size, @total_pages_in_file, @relocation_items, @paragraphs_in_header, @minimum_extra_paragraphs, @maximum_extra_paragraphs, @initial_stack_segment, @initial_stack_pointer, @complemented_checksum, @initial_instraction_pointer, @initial_code_segment, @relocation_table_offset, @overlay_number, @reserved1_1, @reserved1_2, @reserved1_3, @reserved1_4, @oem_identifier, @oem_information, @reserved2_1, @reserved2_2, @reserved2_3, @reserved2_4, @reserved2_5, @reserved2_6, @reserved2_7, @reserved2_8, @reserved2_9, @reserved2_10, @offset_to_new_header].pack(FORMAT)
        end

        def unpack(bin)
          @magic, @last_page_size, @total_pages_in_file, @relocation_items, @paragraphs_in_header, @minimum_extra_paragraphs, @maximum_extra_paragraphs, @initial_stack_segment, @initial_stack_pointer, @complemented_checksum, @initial_instraction_pointer, @initial_code_segment, @relocation_table_offset, @overlay_number, @reserved1_1, @reserved1_2, @reserved1_3, @reserved1_4, @oem_identifier, @oem_information, @reserved2_1, @reserved2_2, @reserved2_3, @reserved2_4, @reserved2_5, @reserved2_6, @reserved2_7, @reserved2_8, @reserved2_9, @reserved2_10, @offset_to_new_header = bin.unpack(FORMAT)
          return self
        end

      end # ImageDosHeader

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
