
#==============================================================================#
# $Id: pe_file.rb,v 1.2 2003/11/22 21:54:39 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/image_dos_header'
require 'exerb/win32/struct/image_nt_headers32'
require 'exerb/win32/struct/image_section_header'

#==============================================================================#

module Exerb

  module Win32

    class PeFile

      def initialize
        @dos_header = nil
        @nt_headers = nil
        @sections   = nil
      end

      attr_accessor :dos_header, :nt_headers, :sections

      def self.read(io)
        return self.new.read(io)
      end

      def read(io)
        @dos_header = Struct::ImageDosHeader.read(io)
        io.seek(-@dos_header.size, IO::SEEK_CUR)
        io.seek(@dos_header.offset_to_new_header, IO::SEEK_CUR)
        @nt_headers = Struct::ImageNtHeaders32.read(io)
        @sections   = (1..@nt_headers.file_header.number_of_sections).collect { Struct::ImageSectionHeader.read(io) }

        return self
      end

    end # PeFile

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
