
#==============================================================================#
# $Id: resource.rb,v 1.16 2003/11/23 14:39:46 yuya Exp $
#==============================================================================#

require 'exerb/version'
require 'exerb/win32/resource_directory'
require 'exerb/win32/resource_directory_root'
require 'exerb/win32/resource_entry'
require 'exerb/win32/resource_entry_data'
require 'exerb/win32/const/resource'
require 'exerb/resource/icon'
require 'exerb/resource/group_icon'
require 'exerb/resource/version_info'
require 'exerb/resource/dialog'

#==============================================================================#

module Exerb

  class Resource

    DEFAULT_LANG_ID = 1041 # Japanese

    def initialize
      @entries = {}
    end

    attr_reader :entries

    def add(type, id, data, lang = DEFAULT_LANG_ID)
      @entries[type] ||= {}
      @entries[type][id] ||= {}
      @entries[type][id][lang] = Entry.new(type, id, data, lang)

      return self
    end

    def add_icon(id, data, lang = DEFAULT_LANG_ID)
      return self.add(Win32::Const::RT_ICON, id, data, lang)
    end

    def add_group_icon(id, data, lang = DEFAULT_LANG_ID)
      return self.add(Win32::Const::RT_GROUP_ICON, id, data, lang)
    end

    def add_dialog(id, data, lang = DEFAULT_LANG_ID)
      return self.add(Win32::Const::RT_DIALOG, id, data, lang)
    end

    def add_version(id, data, lang = DEFAULT_LANG_ID)
      return self.add(Win32::Const::RT_VERSION, id, data, lang)
    end

    def add_default_icon
      ico16x16x16  = DefaultIcon16x16x16.new
      ico16x16x256 = DefaultIcon16x16x256.new
      ico32x32x16  = DefaultIcon32x32x16.new
      ico32x32x256 = DefaultIcon32x32x256.new

      group_icon = GroupIcon.new
      group_icon.add(1, ico32x32x256)
      group_icon.add(2, ico32x32x16)
      group_icon.add(3, ico16x16x256)
      group_icon.add(4, ico16x16x16)

      self.add_icon(1, ico32x32x256)
      self.add_icon(2, ico32x32x16)
      self.add_icon(3, ico16x16x256)
      self.add_icon(4, ico16x16x16)
      self.add_group_icon(102, group_icon)
    end

    def add_default_dialog
      self.add_default_dialog_en
      self.add_default_dialog_ja
    end

    def add_default_dialog_en
      self.add_dialog(101, DefaultDialogEn.new, 1033)
    end

    def add_default_dialog_ja
      self.add_dialog(101, DefaultDialogJa.new)
    end

    def add_default_version_info
      return self.add_version(1, DefaultVersionInfo.new)
    end

    def pack(base, reloc = [])
      root_dir = Win32::ResourceDirectoryRoot.new

      @entries.keys.sort.each { |type|
        root_dir << Win32::ResourceDirectory.new(type) { |type_dir|
          @entries[type].keys.sort.each { |id|
            type_dir << Win32::ResourceDirectory.new(id) { |item_dir|
              @entries[type][id].keys.sort.each { |lang|
                item_dir << @entries[type][id][lang].to_resource_entry
              }
            }
          }
        }
      }

      return root_dir.pack_all(base, reloc)
    end

    class Entry

      def initialize(type, id, data, lang)
        @type = type
        @id   = id
        @data = data
        @lang = lang
      end

      attr_accessor :type, :id, :data, :lang

      def to_resource_entry
        return Win32::ResourceEntry.new(Win32::ResourceEntryData.new(@data.pack), lang)
      end

    end # Entry

  end # Resource

end # Exerb

#==============================================================================#
#==============================================================================#
