
#==============================================================================#
# $Id: resource_entry.rb,v 1.1 2003/11/18 18:46:33 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/image_resource_data_entry'

#==============================================================================#

module Exerb

  module Win32

    class ResourceEntry

      def initialize(entry_data)
        @entry_data = entry_data
      end

      def serialize(elements, level)
        elements[1][level] = [] if elements[1][level].nil?
        elements[1][level] << self
        @entry_data.serialize(elements, level + 1)
        return elements
      end

      def pack(table, delta)
        data = Struct::ImageResourceDataEntry.new
        data.offset_to_data = table[@entry_data] + delta
        data.size           = @entry_data.size
        data.code_page      = 0x0000
        data.reserved       = 0x0000

        return data.pack
      end

    end # ResourceEntry

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
