
#==============================================================================#
# $Id: resource_directory.rb,v 1.1 2003/11/18 18:46:33 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/image_resource_directory'
require 'exerb/win32/struct/image_resource_directory_entry'

#==============================================================================#

module Exerb

  module Win32

    class ResourceDirectory

      def initialize(name)
        @name    = name
        @entries = []
      end

      attr_accessor :name, :entries

      def <<(entry)
        @entries << entry
      end

      def serialize(elements, level)
        elements[0][level] = [] if elements[0][level].nil?
        elements[0][level] << self
        @entries.each { |entry| elements[0][level] << DirectoryEntry.new(entry) }
        @entries.each { |entry| entry.serialize(elements, level + 1) }
        return elements
      end

      def pack(table, delta)
        dir = Struct::ImageResourceDirectory.new
        dir.characteristics        = 0
        dir.time_date_stamp        = 0
        dir.major_version          = 0
        dir.minor_version          = 0
        dir.number_of_name_entries = 0
        dir.number_of_id_entries   = @entries.size

        return dir.pack
      end

      class DirectoryEntry

        def initialize(entry)
          @entry = entry
        end

        attr_accessor :entry

        def pack(table, delta)
          entry = Win32::Struct::ImageResourceDirectoryEntry.new

          if @entry.kind_of?(ResourceDirectory)
            entry.name                = @entry.name
            entry.offset_to_directory = table[@entry]
          else
            entry.name                = 0
            entry.offset_to_data      = table[@entry]
          end

          return entry.pack
        end

      end # DirectoryEntry

    end # ResourceDirectory

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
