
#==============================================================================#
# $Id: archive.rb,v 1.27 2003/11/03 06:31:06 yuya Exp $
#==============================================================================#

require 'exerb/name_table'
require 'exerb/file_table'
require 'exerb/plugin_table'

#==============================================================================#

module Exerb

  class Archive

    def initialize(compress = false)
      @name_table   = NameTable.new
      @file_table   = FileTable.new
      @plugin_table = PluginTable.new
      @compress     = compress
    end

    attr_reader   :name_table, :file_table, :plugin_table
    attr_accessor :compress

    def add_ruby_script(name, data)
      @file_table.add_ruby_script(@name_table.add(name), data)
    end

    def add_ruby_script_from_file(name, path)
      @file_table.add_ruby_script_from_file(@name_table.add(name), path)
    end

    def add_bruby_binary(name, data)
      @file_table.add_bruby_binary(@name_table.add(name), data)
    end

    def add_bruby_binary_from_file(name, path)
      @file_table.add_bruby_binary_from_file(@name_table.add(name), path)
    end

    def add_extension_library(name, data)
      @file_table.add_extension_library(@name_table.add(name), data)
    end

    def add_extension_library_from_file(name, path)
      @file_table.add_extension_library_from_file(@name_table.add(name), path)
    end

    def add_dynamic_library(name, data)
      @file_table.add_dynamic_library(@name_table.add(name), data)
    end

    def add_dynamic_library_from_file(path)
      @file_table.add_dynamic_library_from_file(@name_table.add(File.basename(path)), path)
    end

    def add_resource_library(name, data)
      @file_table.add_resource_library(@name_table.add(name), data)
    end

    def add_resource_library_from_file(path)
      @file_table.add_resource_library_from_file(@name_table.add(File.basename(path)), path)
    end

    def add_data_binary(name, data)
      @file_table.add_data_binary(@name_table.add(name), data)
    end

    def add_data_binary_from_file(name, path)
      @file_table.add_data_binary_from_file(@name_table.add(name), path)
    end

    def add_plugin(data)
      @plugin_table.add(data)
    end

    def add_plugin_from_file(path)
      @plugin_table.add_from_file(path)
    end

    def pack
      packed_name_table   = @name_table.pack
      packed_file_table   = @file_table.pack
      packed_plugin_table = @plugin_table.pack

      packed_file_table = self.compress_binary(packed_file_table) if @compress

      archive_header = Exerb::ArchiveHeader.new
      archive_header.signature              = Exerb::ArchiveHeader::SIGNATURE
      archive_header.offset_of_name_table   = Utility.alignment16(archive_header.pack).size
      archive_header.size_of_name_table     = packed_name_table.size
      archive_header.offset_of_file_table   = archive_header.offset_of_name_table + archive_header.size_of_name_table
      archive_header.size_of_file_table     = packed_file_table.size
      archive_header.offset_of_plugin_table = archive_header.offset_of_file_table + archive_header.size_of_file_table
      archive_header.size_of_plugin_table   = packed_plugin_table.size
      archive_header.options                = 0

      archive_header.options |= ArchiveHeader::OPTIONS_COMPRESSED if @compress

      return Utility.alignment16(archive_header.pack) + packed_name_table + packed_file_table + packed_plugin_table
    end

    def compress_binary(binary)
      require('zlib')
      compressed = Zlib::Deflate.deflate(binary, Zlib::DEFAULT_COMPRESSION)
      return Utility.alignment16([binary.size, compressed.size].pack('LL') + compressed)
    end
    protected :compress_binary

  end # Archive

  class ArchiveHeader

    SIGNATURE          = 0x01004145
    OPTIONS_COMPRESSED = 0x00000001

    def initialize
      @signature              = nil
      @offset_of_name_table   = nil
      @size_of_name_table     = nil
      @offset_of_file_table   = nil
      @size_of_file_table     = nil
      @offset_of_plugin_table = nil
      @size_of_plugin_table   = nil
      @options                = nil
    end

    attr_accessor :signature, :offset_of_name_table, :size_of_name_table, :offset_of_file_table, :size_of_file_table, :offset_of_plugin_table, :size_of_plugin_table, :options

    def pack
      return [@signature, @offset_of_name_table, @size_of_name_table, @offset_of_file_table, @size_of_file_table, @offset_of_plugin_table, @size_of_plugin_table, @options].pack('LLLLLLLL')
    end

  end # ArchiveHeader

end # Exerb

#==============================================================================#
#==============================================================================#
