// $Id: utility.cpp,v 1.7 2003/10/30 04:04:59 yuya Exp $

#include <windows.h>
#include <ruby.h>
#include "utility.h"

////////////////////////////////////////////////////////////////////////////////

extern VALUE rb_eExerbRuntimeError;

////////////////////////////////////////////////////////////////////////////////

char*
exerb_strdup(const char* str)
{
	char *newstr = new char[::strlen(str) + 1];
	::strcpy(newstr, str);
	return newstr;
}

HANDLE
exerb_fopen_for_read(char *filepath)
{
	HANDLE file = ::CreateFile(filepath, GENERIC_READ, 0, NULL, OPEN_EXISTING, NULL, NULL);
	if ( file == INVALID_HANDLE_VALUE ) ::exerb_raise_runtime_error(::GetLastError());

	return file;
}

HANDLE
exerb_fopen_for_write(char *filepath)
{
	HANDLE file = ::CreateFile(filepath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, NULL, NULL);
	if ( file == INVALID_HANDLE_VALUE ) ::exerb_raise_runtime_error(::GetLastError());

	return file;
}

BOOL
exerb_fclose(HANDLE file)
{
	BOOL ret = ::CloseHandle(file);
	if ( !ret ) ::exerb_raise_runtime_error(::GetLastError());

	return ret;
}

DWORD
exerb_fseek(HANDLE file, LONG pos, DWORD method)
{
	DWORD ret = ::SetFilePointer(file, pos, NULL, method);
	//if ( ret == INVALID_SET_FILE_POINTER ) ::exerb_raise_runtime_error(::GetLastError())

	return ret;
}

DWORD
exerb_fread(HANDLE file, void *buffer, int size)
{
	DWORD read_size = 0;
	BOOL  ret = ::ReadFile(file, buffer, size, &read_size, NULL);
	if ( !ret ) {
		DWORD error = ::GetLastError();
		::CloseHandle(file);
		::exerb_raise_runtime_error(error);
	}

	return read_size;
}

DWORD
exerb_fwrite(HANDLE file, void *buffer, int size)
{
	DWORD written = 0;
	BOOL ret = ::WriteFile(file, buffer, size, &written, NULL);
	if ( !ret ) {
		DWORD error = ::GetLastError();
		::CloseHandle(file);
		::exerb_raise_runtime_error(error);
	}

	return written;
}

DWORD
exerb_fsize(HANDLE file)
{
	DWORD size = ::GetFileSize(file, NULL);
	if ( size == (DWORD)-1 ) {
		DWORD error = ::GetLastError();
		::CloseHandle(file);
		::exerb_raise_runtime_error(error);
	}

	return size;
}

void
exerb_get_self_filepath(char *filepath, int size)
{
	DWORD ret = ::GetModuleFileName(NULL, filepath, size);
	if ( !ret ) ::exerb_raise_runtime_error(::GetLastError());
}

char*
exerb_get_filename(char *filepath)
{
	if ( !::strchr(filepath, '\\') && !::strchr(filepath, '/') ) return filepath;

	char fullpath[MAX_PATH] = "";
	char *filename          = NULL;
	::GetFullPathName(filepath, sizeof(fullpath), fullpath, &filename);

	return filename;
}

void
exerb_raise_runtime_error(DWORD error_no)
{
	// insecure
	char message0[1024] = "";
	char message1[1024 + 128] = "";
	::FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, error_no, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), message0, sizeof(message0), NULL);
	::sprintf(message1, "Win32API Error #%i --- %s", error_no, message0);
	::rb_raise(rb_eExerbRuntimeError, message1);
}

////////////////////////////////////////////////////////////////////////////////
