
#==============================================================================#
# $Id: utility.rb,v 1.6 2003/10/27 04:43:35 yuya Exp $
#==============================================================================#

module Exerb

  module Utility

    def self.alignment(bin, align)
      if bin.size % align == 0
        return bin
      else
        return bin + "\0" * (align - (bin.size % align))
      end
    end

    def self.alignment16(bin)
      return alignment(bin, 16)
    end

    def self.find_file_by_filename(filename, path1, path2)
      return filename if File.expand_path(filename) == filename && File.exist?(filename)
      list  = path1.collect { |dir| File.join(dir, 'exerb', filename) }
      list += path2.collect { |dir| File.join(dir, filename) }
      return list.find { |filepath| File.exist?(filepath) }
    end

    def self.find_file_by_name(name, table, path1, path2)
      filename = table[name]
      return nil if filename.nil?
      return self.find_file_by_filename(filename, path1, path2)
    end

    def self.find_core_by_filename(filename)
      return self.find_file_by_filename(filename, $LOAD_PATH, CORE_PATH)
    end

    def self.find_core_by_name(name, error = false)
      path = self.find_file_by_name(name, CORE_NAME, $LOAD_PATH, CORE_PATH)
      raise(ExerbError, "unknown core name --- #{name}") if path.nil? && error
      return path
    end

    def self.find_plugin_by_filename(filename)
      return self.find_file_by_filename(filename, $LOAD_PATH, PLUGIN_PATH)
    end

    def self.find_plugin_by_name(name)
      return self.find_file_by_name(name, PLUGIN_NAME, $LOAD_PATH, PLUGIN_PATH)
    end

  end # Utility

end # Exerb

#==============================================================================#
#==============================================================================#
