
#==============================================================================#
# $Id: mkrbc.rb,v 1.7 2003/10/25 16:08:32 yuya Exp $
#==============================================================================#

END {
  files = [['script', $0, $0]]

  $".sort.each { |filename|
    next if /#{File.basename(__FILE__)}$/ =~ filename

    type = case filename
           when /\.rb$/i       then "add_ruby_script"
           when /\.(so|dll)$/i then "add_extension_library"
           else "#unknown"
           end

    if File.exist?(filename)
      files << [type, filename, filename]
    else
      $LOAD_PATH.each { |path|
        filepath = File.join(path, filename)
        if File.exist?(filepath)
          files << [type, filename, filepath]
          break
        end
      }
    end
  }

  rbcfile = $0.sub(/\.rb$/, '.rbc')
  rbcfile << ".rbc" unless /\.rbc$/ =~ rbcfile
  makfile = $0.sub(/\.rb$/, '.mak')
  makfile << ".mak" unless /\.mak$/ =~ makfile
  exefile = $0.sub(/\.rb$/, '.exe')
  exefile << ".exe" unless /\.exe$/ =~ exefile

  File.open(rbcfile, 'w') { |file|
    file.puts "# generated by mkrbc.rb"
    file.puts "set_kcode\t#{$KCODE.downcase}"
    files.each { |type, internalname, filename|
      if internalname == filename
        file.puts "#{type}\t#{internalname}"
      else
        file.puts "#{type}\t#{internalname}\t#{filename}"
      end
    }
  }

  File.open(makfile, 'w') { |file|
    file.puts "# generated by mkrbc.rb"
    file.puts
    file.puts "EXERB  = exerb"
    file.puts "OUTPUT = #{exefile}"
    file.puts "INPUT  = #{rbcfile}"
    file.puts "FILES  = " + files.collect { |type, internalname, filename| filename }.join(" ")
    file.puts
    file.puts "all: $(OUTPUT)"
    file.puts
    file.puts "$(OUTPUT): $(INPUT) $(FILES)"
    file.puts "\t$(EXERB) $(INPUT)"
    file.puts "\tchmod +x $(OUTPUT)"
    file.puts
    file.puts "go: all"
    file.puts "\t$(OUTPUT)"
    file.puts
    file.puts "clean:"
    file.puts "\trm $(OUTPUT)"
  }
}

#==============================================================================#
#==============================================================================#
