#! /usr/bin/ruby

#====================================================================#
# join.rb
#====================================================================#

#====================================================================#
# Require

require File.join(File.dirname(__FILE__), 'r2e')

#====================================================================#
# Main Program

if ARGV.size < 3
  puts('Usage: ruby join.rb <core> <archive> <output>')
  exit(1)
end

core_filepath    = ARGV[0]
archive_filepath = ARGV[1]
output_filepath  = ARGV[2]

archive   = R2E::Binary::Archive.new_from_file(archive_filepath)
core      = R2E::Binary::Core.new_from_file(core_filepath)
exectable = R2E::Binary::Executable.new(archive, core)
exectable.selfcheck
exectable.output_to_file(output_filepath)

puts('ok')
exit(0)

#====================================================================#
# End of source.
#====================================================================#
