#! /usr/bin/ruby -Ke

#====================================================================#
# archive.rb
#====================================================================#

#====================================================================#
# Require

require File.join(File.dirname(__FILE__), 'r2e')

#====================================================================#
# Main Program

if ARGV.size < 2
  puts('Usage: ruby archive.rb <archive-list> <archive>')
  exit(1)
end

list_filepath   = ARGV[0]
output_filepath = ARGV[1]

archive = R2E::Archive.new
base    = File.dirname(File.expand_path(list_filepath))

File.open(list_filepath) { |file|
  file.to_a
}.collect { |item|
  item.strip
}.reject { |item|
  item.empty? || /^#/ =~ item
}.collect { |item|
  item.split(/\t+/)
}.each { |type, name, path|
  filepath = File.join(base, path)
  case type
  when 'kcode'   then archive.set_kcode(name)
  when 'script'  then archive.add_script(name, filepath)
  when 'library' then archive.add_dll(name, filepath)
  else raise 'syntax error'
  end
}

archive.output_to_file(output_filepath)

puts('ok')
exit(0)

#====================================================================#
# End of source.
#====================================================================#
