=begin

= Exerb

== Overview

Exerb is the software which converts scripts/extension-libraries
of the object oriented language Ruby into a Windows excutable file
which can excute alone and independetly.

== Features

* Exerb can convert a number of files(script, extension-library)
into a excutable file in one piece.
* A excutable file which is created by Exerb can excute on a
environment Ruby is not installed, because the excutable file
contains Ruby.
* Any compiler is not needed to creat a excutable file.

== Usage

Exerb is constructed from two scripts.

=== archive.rb

"archive.rb" reads an archive list file, and converts a number of
scripts and extension-libraries into an archive file. Form is as
follows.

  $ ruby archive.rb <archive-list-file> <archive-file>

==== Archive list

The archive list file contains file names and it's internal names
will be store in the archive file. An example is as follows.

  # comment line
  script	main.rb		sample/sample1.rb
  library	Win32API.so	sample/Win32API.so

The line begin with "#" is a comment.
The line begin with "script" is a specification of a script file.
The line begin with "library" is a specification of a
extension-library.

"script" and "library" is described in a form as follows.

  <script or library><one or more tab><internal name><one or more tab><file name>

The internal name is a file name when it was stored in the
archive file. That is used by require, back tracing and other.
The file name is a file name which is read actually.

The first script file in the archive is excuted at running time
of the excutable file. The first script file is the first
specified "script" in other words.

=== join.rb

"join.rb" creates an excutable file by joinning the archive file
created by "archive.rb" and the core file contains Ruby. Form is
as follows.

 $ ruby join.rb <core-file> <archive-file> <excutable-file-will-be-created>

== Sample

The following samples are in the example directory.

: sample1
    This is the sample which displays a message box using
    Win32API.

: sample2
    This is the sample which occurs an exception and displays an
    exception dialog.

: sample3
    This is the sample which displays a window using
    VisualuRuby.

To convert sample1 into an excutable file, do as followings.

  $ cd example
  $ ruby ../bin/archive.rb sample1.rbc sample1.rba
  $ ruby ../bin/join.rb ../bin/ruby167g.rbx sample1.rba sample1.exe

You can convert sample2 and sample3 in same method.

== How to get

You can get the latest infomation and version of Exerb at the
following URL.

((<URL:http://sourceforge.jp/projects/exerb/>))

And You can get the infomation and source code of Ruby at the
following URL.

((<URL:http://www.ruby-lang.org/>))

== Development environment

* Microsoft Windows2000 SP2
* Microsoft VisualC++ 6.0

== Checking emvironment

We checked out that the excutable file created by Exerb can run
on following environments.

* Microsoft WindowsXP
* Microsoft Windows2000 SP2
* Microsoft WindowsMe
* Microsoft Windows98 SecondEdition
* Microsoft Windows98
* Microsoft Windows95

== License

You can redistribute it and/or modify it under the terms of the	LGPL.

== Copyright and Exemption from responsibility

* The Ruby part of Exerb is copyrighted by Yukihiro Matsumoto
and the people who is concerned in the development of it.
* The other patrs is copyrighted by Yuya Kato.
* THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.

== Acknowledgment

We would like to thank Yukihiro Matsumoto and the other people
who is concerned in the development of the Great language Ruby.
Thanks for the great language!

== Point of contact

The mail address of Yuya Kato who is the author of Exerb is
bellow.
We will be happy if you send me your advices, impressions,
demands or bag reports.

yuya@katoden.co.jp

== And

Good Ruby life.:-)

=end
